/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.elasticsearch;

import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.hawkular.btm.api.model.trace.CorrelationIdentifier;
import org.hawkular.btm.api.services.Criteria;

public class ElasticsearchUtil {
    public static BoolQueryBuilder buildQuery(Criteria criteria, String timeProperty, String businessTxnProperty) {
        long startTime = criteria.calculateStartTime();
        long endTime = criteria.calculateEndTime();
        BoolQueryBuilder query = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.rangeQuery((String)timeProperty).from(startTime).to(endTime));
        if (criteria.getBusinessTransaction() != null && criteria.getBusinessTransaction().trim().length() > 0) {
            query = query.must((QueryBuilder)QueryBuilders.termQuery((String)businessTxnProperty, (String)criteria.getBusinessTransaction()));
        }
        if (!criteria.getProperties().isEmpty()) {
            for (Criteria.PropertyCriteria pc : criteria.getProperties()) {
                if (pc.isExcluded()) {
                    query = query.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)("properties." + pc.getName()), (Object)pc.getValue()));
                    continue;
                }
                query = query.must((QueryBuilder)QueryBuilders.matchQuery((String)("properties." + pc.getName()), (Object)pc.getValue()));
            }
        }
        if (criteria.getHostName() != null && criteria.getHostName().trim().length() > 0) {
            query = query.must((QueryBuilder)QueryBuilders.matchQuery((String)"hostName", (Object)criteria.getHostName()));
        }
        if (criteria.getPrincipal() != null && criteria.getPrincipal().trim().length() > 0) {
            query = query.must((QueryBuilder)QueryBuilders.matchQuery((String)"principal", (Object)criteria.getPrincipal()));
        }
        if (!criteria.getCorrelationIds().isEmpty()) {
            for (CorrelationIdentifier id : criteria.getCorrelationIds()) {
                query.must((QueryBuilder)QueryBuilders.termQuery((String)"value", (String)id.getValue()));
            }
        }
        if (!criteria.getFaults().isEmpty()) {
            for (Criteria.FaultCriteria fc : criteria.getFaults()) {
                if (fc.isExcluded()) {
                    query = query.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"fault", (Object)fc.getValue()));
                    continue;
                }
                query = query.must((QueryBuilder)QueryBuilders.matchQuery((String)"fault", (Object)fc.getValue()));
            }
        }
        if (criteria.getLowerBound() > 0L || criteria.getUpperBound() > 0L) {
            RangeQueryBuilder rangeQuery = QueryBuilders.rangeQuery((String)"duration");
            if (criteria.getLowerBound() > 0L) {
                rangeQuery.gte(criteria.getLowerBound());
            }
            if (criteria.getUpperBound() > 0L) {
                rangeQuery.lte(criteria.getUpperBound());
            }
            query = query.must((QueryBuilder)rangeQuery);
        }
        return query;
    }

    public static FilterBuilder buildFilter(Criteria criteria) {
        if (criteria.getBusinessTransaction() != null && criteria.getBusinessTransaction().trim().length() == 0) {
            return FilterBuilders.missingFilter((String)"businessTransaction");
        }
        return null;
    }
}

