/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.SortOrder;
import org.hawkular.btm.api.model.trace.Trace;
import org.hawkular.btm.api.services.Criteria;
import org.hawkular.btm.api.services.TraceService;
import org.hawkular.btm.server.elasticsearch.ElasticsearchClient;
import org.hawkular.btm.server.elasticsearch.ElasticsearchUtil;
import org.hawkular.btm.server.elasticsearch.log.MsgLogger;

public class TraceServiceElasticsearch
implements TraceService {
    private static final MsgLogger msgLog = MsgLogger.LOGGER;
    public static final String TRACE_TYPE = "trace";
    private static final ObjectMapper mapper = new ObjectMapper();
    @Inject
    private ElasticsearchClient client;

    public ElasticsearchClient getElasticsearchClient() {
        return this.client;
    }

    public void setElasticsearchClient(ElasticsearchClient client) {
        this.client = client;
    }

    public Trace get(String tenantId, String id) {
        Trace ret = null;
        GetResponse response = (GetResponse)this.client.getElasticsearchClient().prepareGet(this.client.getIndex(tenantId), TRACE_TYPE, id).setRouting(id).execute().actionGet();
        if (!response.isSourceEmpty()) {
            try {
                ret = (Trace)mapper.readValue(response.getSourceAsString(), Trace.class);
            }
            catch (Exception e) {
                msgLog.errorFailedToParse(e);
            }
        }
        if (msgLog.isTraceEnabled()) {
            msgLog.tracef("Get trace with id[%s] is: %s", id, ret);
        }
        return ret;
    }

    public List<Trace> query(String tenantId, Criteria criteria) {
        return TraceServiceElasticsearch.internalQuery(this.client, tenantId, criteria);
    }

    protected static List<Trace> internalQuery(ElasticsearchClient client, String tenantId, Criteria criteria) {
        ArrayList<Trace> ret;
        block10: {
            ret = new ArrayList<Trace>();
            String index = client.getIndex(tenantId);
            try {
                SearchResponse response;
                RefreshRequestBuilder refreshRequestBuilder = client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
                client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "startTime", "businessTransaction");
                SearchRequestBuilder request = client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{TRACE_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(criteria.getMaxResponseSize()).setQuery((QueryBuilder)query).addSort("startTime", SortOrder.ASC);
                FilterBuilder filter = ElasticsearchUtil.buildFilter(criteria);
                if (filter != null) {
                    request.setPostFilter(filter);
                }
                if ((response = (SearchResponse)request.execute().actionGet()).isTimedOut()) {
                    msgLog.warnQueryTimedOut();
                }
                for (SearchHit searchHitFields : response.getHits()) {
                    try {
                        ret.add((Trace)mapper.readValue(searchHitFields.getSourceAsString(), Trace.class));
                    }
                    catch (Exception e) {
                        msgLog.errorFailedToParse(e);
                    }
                }
                if (msgLog.isTraceEnabled()) {
                    msgLog.tracef("Query traces with criteria[%s] is: %s", criteria, ret);
                }
            }
            catch (IndexMissingException ime) {
                if (msgLog.isTraceEnabled()) {
                    msgLog.tracef("No index found, so unable to retrieve traces", new Object[0]);
                }
            }
            catch (SearchPhaseExecutionException spee) {
                if (!msgLog.isTraceEnabled()) break block10;
                msgLog.tracef("Failed to get fragments", (Object)spee);
            }
        }
        return ret;
    }

    public void storeTraces(String tenantId, List<Trace> traces) throws Exception {
        this.client.initTenant(tenantId);
        BulkRequestBuilder bulkRequestBuilder = this.client.getElasticsearchClient().prepareBulk();
        for (int i = 0; i < traces.size(); ++i) {
            Trace trace = traces.get(i);
            String json = mapper.writeValueAsString((Object)trace);
            if (msgLog.isTraceEnabled()) {
                msgLog.tracef("Storing trace: %s", json);
            }
            bulkRequestBuilder.add(this.client.getElasticsearchClient().prepareIndex(this.client.getIndex(tenantId), TRACE_TYPE, trace.getId()).setSource(json));
        }
        BulkResponse bulkItemResponses = (BulkResponse)bulkRequestBuilder.execute().actionGet();
        if (bulkItemResponses.hasFailures()) {
            msgLog.error("Failed to store traces: " + bulkItemResponses.buildFailureMessage());
            if (msgLog.isTraceEnabled()) {
                msgLog.trace("Failed to store traces to elasticsearch: " + bulkItemResponses.buildFailureMessage());
            }
        } else if (msgLog.isTraceEnabled()) {
            msgLog.trace("Success storing traces to elasticsearch");
        }
    }

    public void clear(String tenantId) {
        String index = this.client.getIndex(tenantId);
        try {
            this.client.getElasticsearchClient().admin().indices().prepareDelete(new String[]{index}).execute().actionGet();
            this.client.clear(tenantId);
        }
        catch (IndexMissingException indexMissingException) {
            // empty catch block
        }
    }
}

