/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.infinispan;

import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.hawkular.btm.api.model.events.CommunicationDetails;
import org.hawkular.btm.processor.btxncompletiontime.CommunicationDetailsCache;
import org.infinispan.Cache;
import org.infinispan.manager.CacheContainer;

@Singleton
public class InfinispanCommunicationDetailsCache
implements CommunicationDetailsCache {
    @Resource(lookup="java:jboss/infinispan/BTM")
    private CacheContainer container;
    private Cache<String, CommunicationDetails> communicationDetails;

    @PostConstruct
    public void init() {
        this.communicationDetails = this.container.getCache("communicationdetails");
    }

    public Cache<String, CommunicationDetails> getCommunicationDetails() {
        return this.communicationDetails;
    }

    public void setCommunicationDetails(Cache<String, CommunicationDetails> communicationDetails) {
        this.communicationDetails = communicationDetails;
    }

    public CommunicationDetails getSingleConsumer(String tenantId, String id) {
        return (CommunicationDetails)this.communicationDetails.get((Object)id);
    }

    public List<CommunicationDetails> getMultipleConsumers(String tenantId, String id) {
        return null;
    }

    public void store(String tenantId, List<CommunicationDetails> details) {
        for (int i = 0; i < details.size(); ++i) {
            CommunicationDetails cd = details.get(i);
            String id = cd.getId();
            if (cd.isMultiConsumer()) {
                id = cd.getTargetFragmentId();
            }
            this.communicationDetails.put((Object)id, (Object)cd, 1L, TimeUnit.MINUTES);
        }
    }
}

