/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.jms;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.inject.Inject;
import javax.jms.MessageListener;
import org.hawkular.btm.api.model.events.ResponseTime;
import org.hawkular.btm.api.services.AnalyticsService;
import org.hawkular.btm.server.jms.ResponseTimePublisherJMS;
import org.hawkular.btm.server.jms.RetryCapableMDB;

@MessageDriven(name="ResponseTimes_Store", messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="ResponseTimes"), @ActivationConfigProperty(propertyName="subscriptionDurability", propertyValue="Durable"), @ActivationConfigProperty(propertyName="clientId", propertyValue="ResponseTimeStore"), @ActivationConfigProperty(propertyName="subscriptionName", propertyValue="ResponseTimeStore")})
@TransactionManagement(value=TransactionManagementType.CONTAINER)
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class ResponseTimeStoreMDB
extends RetryCapableMDB<ResponseTime> {
    @Inject
    private ResponseTimePublisherJMS responseTimePublisher;
    @Inject
    private AnalyticsService analyticsService;

    @PostConstruct
    public void init() {
        this.setRetryPublisher(this.responseTimePublisher);
        this.setTypeReference(new TypeReference<List<ResponseTime>>(){});
    }

    @Override
    protected void process(String tenantId, List<ResponseTime> items, int retryCount) throws Exception {
        this.analyticsService.storeResponseTimes(tenantId, items);
    }
}

