/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.jms;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.hawkular.btm.server.jms.AbstractPublisherJMS;

public abstract class RetryCapableMDB<S>
implements MessageListener {
    private static final Logger log = Logger.getLogger(RetryCapableMDB.class.getName());
    private static final ObjectMapper mapper = new ObjectMapper();
    private TypeReference<List<S>> typeReference;
    private AbstractPublisherJMS<S> retryPublisher;

    public AbstractPublisherJMS<S> getRetryPublisher() {
        return this.retryPublisher;
    }

    public void setRetryPublisher(AbstractPublisherJMS<S> retryPublisher) {
        this.retryPublisher = retryPublisher;
    }

    public TypeReference<List<S>> getTypeReference() {
        return this.typeReference;
    }

    public void setTypeReference(TypeReference<List<S>> typeReference) {
        this.typeReference = typeReference;
    }

    public void onMessage(Message message) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Message received=" + message);
        }
        try {
            String tenantId = message.getStringProperty("tenant");
            int retryCount = message.propertyExists("retryCount") ? message.getIntProperty("retryCount") : 3;
            String data = ((TextMessage)message).getText();
            List items = (List)mapper.readValue(data, this.getTypeReference());
            this.process(tenantId, items, retryCount);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected abstract void process(String var1, List<S> var2, int var3) throws Exception;
}

