/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.jms;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.hawkular.btm.server.jms.log.MsgLogger;

public abstract class AbstractPublisherJMS<T> {
    private static final Logger log = Logger.getLogger(AbstractPublisherJMS.class.getName());
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private static ObjectMapper mapper = new ObjectMapper();
    private Connection connection;
    private Session session;
    private MessageProducer producer;

    protected abstract String getDestinationURI();

    @PostConstruct
    public void init() {
        try {
            InitialContext context = new InitialContext();
            ConnectionFactory connectionFactory = (ConnectionFactory)context.lookup("java:/JmsXA");
            this.connection = connectionFactory.createConnection();
            this.session = this.connection.createSession(false, 1);
            Destination destination = (Destination)context.lookup(this.getDestinationURI());
            this.producer = this.session.createProducer(destination);
            this.connection.start();
        }
        catch (Exception e) {
            this.msgLog.errorFailedToInitPublisher(this.getDestinationURI(), e);
        }
    }

    @PreDestroy
    public void close() {
        try {
            if (this.session != null) {
                this.session.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception e) {
            this.msgLog.errorFailedToClosePublisher(this.getDestinationURI(), e);
        }
    }

    public void publish(String tenantId, List<T> items, int retryCount) throws Exception {
        this.doPublish(tenantId, items, retryCount);
    }

    protected void doPublish(String tenantId, List<T> items, int retryCount) throws Exception {
        String data = mapper.writeValueAsString(items);
        TextMessage tm = this.session.createTextMessage(data);
        if (tenantId != null) {
            tm.setStringProperty("tenant", tenantId);
        }
        tm.setIntProperty("retryCount", retryCount);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Publish: " + tm);
        }
        this.producer.send((Message)tm);
    }
}

