/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.jms;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.inject.Inject;
import javax.jms.MessageListener;
import org.hawkular.btm.api.model.events.CompletionTime;
import org.hawkular.btm.api.services.AnalyticsService;
import org.hawkular.btm.server.jms.CompletionTimePublisherJMS;
import org.hawkular.btm.server.jms.RetryCapableMDB;

@MessageDriven(name="CompletionTimes_Store", messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="CompletionTimes"), @ActivationConfigProperty(propertyName="subscriptionDurability", propertyValue="Durable"), @ActivationConfigProperty(propertyName="clientId", propertyValue="CompletionTimeStore"), @ActivationConfigProperty(propertyName="subscriptionName", propertyValue="CompletionTimeStore")})
@TransactionManagement(value=TransactionManagementType.CONTAINER)
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class CompletionTimeStoreMDB
extends RetryCapableMDB<CompletionTime> {
    @Inject
    private CompletionTimePublisherJMS completionTimePublisher;
    @Inject
    private AnalyticsService analyticsService;

    @PostConstruct
    public void init() {
        this.setRetryPublisher(this.completionTimePublisher);
        this.setTypeReference(new TypeReference<List<CompletionTime>>(){});
    }

    @Override
    protected void process(String tenantId, List<CompletionTime> items, int retryCount) throws Exception {
        this.analyticsService.storeCompletionTimes(tenantId, items);
    }
}

