/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.jms;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.inject.Inject;
import javax.jms.MessageListener;
import org.hawkular.btm.api.model.events.CommunicationDetails;
import org.hawkular.btm.processor.btxncompletiontime.CommunicationDetailsCache;
import org.hawkular.btm.server.jms.CommunicationDetailsPublisherJMS;
import org.hawkular.btm.server.jms.RetryCapableMDB;

@MessageDriven(name="CommunicationDetails_Cache", messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="CommunicationDetails"), @ActivationConfigProperty(propertyName="subscriptionDurability", propertyValue="Durable"), @ActivationConfigProperty(propertyName="clientID", propertyValue="CommunicationDetailsCache"), @ActivationConfigProperty(propertyName="subscriptionName", propertyValue="CommunicationDetailsCache")})
@TransactionManagement(value=TransactionManagementType.CONTAINER)
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class CommunicationDetailsCacheMDB
extends RetryCapableMDB<CommunicationDetails> {
    @Inject
    private CommunicationDetailsPublisherJMS communicationDetailsPublisher;
    @Inject
    private CommunicationDetailsCache communicationDetailsCache;

    @PostConstruct
    public void init() {
        this.setRetryPublisher(this.communicationDetailsPublisher);
        this.setTypeReference(new TypeReference<List<CommunicationDetails>>(){});
    }

    @Override
    protected void process(String tenantId, List<CommunicationDetails> items, int retryCount) throws Exception {
        this.communicationDetailsCache.store(tenantId, items);
    }
}

