/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.jms;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.inject.Inject;
import javax.jms.MessageListener;
import org.hawkular.btm.api.model.trace.Trace;
import org.hawkular.btm.api.services.TraceService;
import org.hawkular.btm.server.jms.RetryCapableMDB;
import org.hawkular.btm.server.jms.TracePublisherJMS;

@MessageDriven(name="Trace_Store", messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="Traces"), @ActivationConfigProperty(propertyName="subscriptionDurability", propertyValue="Durable"), @ActivationConfigProperty(propertyName="clientID", propertyValue="TraceStore"), @ActivationConfigProperty(propertyName="subscriptionName", propertyValue="TraceStore")})
@TransactionManagement(value=TransactionManagementType.CONTAINER)
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class TraceStoreMDB
extends RetryCapableMDB<Trace> {
    private static final Logger perfLog = Logger.getLogger("org.hawkular.btm.performance.trace");
    @Inject
    private TracePublisherJMS tracePublisher;
    @Inject
    private TraceService traceService;

    @PostConstruct
    public void init() {
        this.setRetryPublisher(this.tracePublisher);
        this.setTypeReference(new TypeReference<List<Trace>>(){});
    }

    @Override
    protected void process(String tenantId, List<Trace> items, int retryCount) throws Exception {
        long startTime = 0L;
        if (perfLog.isLoggable(Level.FINEST)) {
            startTime = System.currentTimeMillis();
            perfLog.finest("Performance: about to store trace (first id=" + items.get(0).getId() + ")");
        }
        this.traceService.storeTraces(tenantId, items);
        if (perfLog.isLoggable(Level.FINEST)) {
            perfLog.finest("Performance: store trace (first id=" + items.get(0).getId() + ") duration=" + (System.currentTimeMillis() - startTime) + "ms");
        }
    }
}

