/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.tests.server;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.config.CollectorConfiguration;
import org.hawkular.btm.api.services.ConfigurationLoader;

public class TestBTMServer {
    private static final String HAWKULAR_BTM_TEST_SERVER_HOST = "hawkular-btm.test.server.host";
    private static final String HAWKULAR_BTM_TEST_SERVER_PORT = "hawkular-btm.test.server.port";
    private static final String HAWKULAR_BTM_TEST_SERVER_SHUTDOWN = "hawkular-btm.test.server.shutdown";
    private static final int DEFAULT_SHUTDOWN_TIMER = 30000;
    private static final Logger log = Logger.getLogger(TestBTMServer.class.getName());
    private Undertow server = null;
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final TypeReference<List<BusinessTransaction>> BUSINESS_TXN_LIST = new TypeReference<List<BusinessTransaction>>(){};
    private List<BusinessTransaction> businessTransactions = new ArrayList<BusinessTransaction>();
    private int port = 8080;
    private String host = "localhost";
    private int shutdown = 30000;
    private CollectorConfiguration testConfig;

    public TestBTMServer() {
        if (System.getProperties().containsKey(HAWKULAR_BTM_TEST_SERVER_HOST)) {
            this.host = System.getProperty(HAWKULAR_BTM_TEST_SERVER_HOST);
        }
        if (System.getProperties().containsKey(HAWKULAR_BTM_TEST_SERVER_PORT)) {
            this.port = Integer.parseInt(System.getProperty(HAWKULAR_BTM_TEST_SERVER_PORT));
        }
        if (System.getProperties().containsKey(HAWKULAR_BTM_TEST_SERVER_SHUTDOWN)) {
            this.shutdown = Integer.parseInt(System.getProperty(HAWKULAR_BTM_TEST_SERVER_SHUTDOWN));
        }
    }

    public static void main(String[] args) {
        TestBTMServer main = new TestBTMServer();
        main.run();
    }

    public List<BusinessTransaction> getBusinessTransactions() {
        return this.businessTransactions;
    }

    public void setBusinessTransactions(List<BusinessTransaction> businessTransactions) {
        this.businessTransactions = businessTransactions;
    }

    public void setShutdownTimer(int timer) {
        this.shutdown = timer;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setTestConfig(CollectorConfiguration testConfig) {
        this.testConfig = testConfig;
    }

    public void run() {
        log.info("************** STARTED TEST BTXN SERVICE: host=" + this.host + " port=" + this.port + " shutdownTimer=" + this.shutdown);
        if (this.shutdown != -1) {
            Thread t = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    2 var1_1 = this;
                    synchronized (var1_1) {
                        try {
                            this.wait(TestBTMServer.this.shutdown);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    log.severe("************** ABORTING TEST BTXN SERVICE");
                    System.exit(1);
                }
            });
            t.setDaemon(true);
            t.start();
        }
        this.server = Undertow.builder().addHttpListener(this.port, this.host).setHandler((HttpHandler)Handlers.path().addPrefixPath("hawkular/btm/shutdown", new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                log.info("Shutdown called");
                exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/plain");
                exchange.getResponseSender().send("ok");
                TestBTMServer.this.shutdown();
            }
        }).addPrefixPath("hawkular/btm/fragments", new HttpHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleRequest(HttpServerExchange exchange) throws Exception {
                if (exchange.isInIoThread()) {
                    exchange.dispatch((HttpHandler)this);
                    return;
                }
                log.info("Transactions request received: " + exchange);
                if (exchange.getRequestMethod() == Methods.POST) {
                    exchange.startBlocking();
                    InputStream is = exchange.getInputStream();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                    StringBuilder builder = new StringBuilder();
                    String str = null;
                    while ((str = reader.readLine()) != null) {
                        builder.append(str);
                    }
                    is.close();
                    List btxns = (List)mapper.readValue(builder.toString(), BUSINESS_TXN_LIST);
                    List list = TestBTMServer.this.businessTransactions;
                    synchronized (list) {
                        TestBTMServer.this.businessTransactions.addAll(btxns);
                    }
                    exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/plain");
                    exchange.getResponseSender().send("");
                } else if (exchange.getRequestMethod() == Methods.GET) {
                    List list = TestBTMServer.this.businessTransactions;
                    synchronized (list) {
                        String btxns = mapper.writeValueAsString((Object)TestBTMServer.this.businessTransactions);
                        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
                        exchange.getResponseSender().send(btxns);
                    }
                }
            }
        }).addPrefixPath("hawkular/btm/config/collector", new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                if (exchange.isInIoThread()) {
                    exchange.dispatch((HttpHandler)this);
                    return;
                }
                log.info("Config request received: " + exchange);
                if (exchange.getRequestMethod() == Methods.GET) {
                    CollectorConfiguration config = ConfigurationLoader.getConfiguration();
                    if (TestBTMServer.this.testConfig != null) {
                        config.merge(TestBTMServer.this.testConfig, true);
                    }
                    String cc = mapper.writeValueAsString((Object)config);
                    exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
                    exchange.getResponseSender().send(cc);
                }
            }
        })).build();
        this.server.start();
    }

    public void shutdown() {
        log.info("************ TEST BTXN SERVICE EXITING");
        this.server.stop();
    }
}

