/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.common;

import java.io.IOException;
import java.io.InputStream;

public class BinaryData
extends InputStream {
    private byte[] inMemoryData;
    private final InputStream streamData;
    private int inMemoryDataPointer;
    private Runnable onCloseAction;

    public BinaryData(byte[] inMemoryData, InputStream streamData) {
        this.inMemoryData = inMemoryData != null ? inMemoryData : new byte[]{};
        this.streamData = streamData;
        this.inMemoryDataPointer = 0;
        this.onCloseAction = null;
    }

    public void setOnCloseAction(Runnable action) {
        this.onCloseAction = action;
    }

    @Override
    public int read() throws IOException {
        if (this.unreadInMemoryDataExists()) {
            return this.inMemoryData[this.inMemoryDataPointer++] & 0xFF;
        }
        return this.streamData.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.unreadInMemoryDataExists()) {
            return super.read(b);
        }
        return this.streamData.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.unreadInMemoryDataExists()) {
            return super.read(b, off, len);
        }
        return this.streamData.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.unreadInMemoryDataExists()) {
            return super.skip(n);
        }
        return this.streamData.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.inMemoryData.length - this.inMemoryDataPointer + this.streamData.available();
    }

    @Override
    public void close() throws IOException {
        this.inMemoryData = new byte[0];
        this.inMemoryDataPointer = 0;
        this.streamData.close();
        if (this.onCloseAction != null) {
            this.onCloseAction.run();
        }
    }

    @Override
    public void mark(int readlimit) {
        super.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        super.reset();
    }

    @Override
    public boolean markSupported() {
        return super.markSupported();
    }

    private boolean unreadInMemoryDataExists() {
        return this.inMemoryDataPointer < this.inMemoryData.length;
    }
}

