/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.cmdgw.ws.test;

import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.squareup.okhttp.ws.WebSocket;
import com.squareup.okhttp.ws.WebSocketCall;
import com.squareup.okhttp.ws.WebSocketListener;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import okio.Buffer;
import okio.BufferedSource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.StringDescription;
import org.hamcrest.TypeSafeMatcher;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.cmdgw.api.ApiDeserializer;
import org.hawkular.cmdgw.api.WelcomeResponse;
import org.hawkular.cmdgw.ws.test.AbstractCommandITest;
import org.testng.Assert;

public class TestWebSocketClient
implements Closeable {
    private static final Logger log = Logger.getLogger(TestWebSocketClient.class.getName());
    protected final OkHttpClient client;
    private final TestListener listener;

    public static Builder builder() {
        return new Builder();
    }

    private TestWebSocketClient(Request request, TestListener testListener) {
        if (request == null) {
            throw new IllegalStateException("Cannot build a [" + TestWebSocketClient.class.getName() + "] with a null request");
        }
        this.listener = testListener;
        this.client = new OkHttpClient();
        WebSocketCall.create((OkHttpClient)this.client, (Request)request).enqueue((WebSocketListener)testListener);
    }

    @Override
    public void close() throws IOException {
        ExecutorService executor = this.client.getDispatcher().getExecutorService();
        executor.shutdown();
        try {
            executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void validate(long timeout) throws Throwable {
        this.listener.validate(timeout);
    }

    public static class ZipWithOneEntryMatcher
    extends TypeSafeMatcher<InputStream> {
        public void describeTo(Description description) {
            description.appendText("expected ZIP stream");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected boolean matchesSafely(InputStream in) {
            try (ZipInputStream zipInputStream = new ZipInputStream(in);){
                ZipEntry entry = zipInputStream.getNextEntry();
                Assert.assertNotNull((Object)entry);
                Assert.assertNotNull((Object)entry.getName());
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                throw new RuntimeException();
            }
        }
    }

    public static class WelcomeMatcher
    extends PatternMatcher {
        private String sessionId;

        public WelcomeMatcher() {
            super("\\QWelcomeResponse={\"sessionId\":\"\\E.*");
        }

        public String getSessionId() {
            return this.sessionId;
        }

        @Override
        public boolean matches(ReusableBuffer actual, TestListener testListener) {
            if (super.matches(actual, testListener)) {
                BasicMessageWithExtraData envelope = new ApiDeserializer().deserialize(actual.getTextPart());
                String sessionId = ((WelcomeResponse)envelope.getBasicMessage()).getSessionId();
                testListener.sessionId = sessionId;
                return true;
            }
            return false;
        }
    }

    protected static interface WebSocketArgumentMatcher<T>
    extends org.hamcrest.Matcher<T> {
        default public boolean matches(T actual, TestListener testListener) {
            return this.matches(actual);
        }
    }

    public static class TestListener
    implements WebSocketListener {
        private boolean closed;
        private final BlockingQueue<List<MessageReport>> conversationResult;
        private final List<ExpectedEvent> expectedEvents;
        private int inMessageCounter = 0;
        private final List<MessageReport> reports = new ArrayList<MessageReport>();
        private final ExecutorService sendExecutor;
        private String sessionId;
        private WebSocket webSocket;

        private TestListener(List<ExpectedEvent> expectedEvents) {
            this.expectedEvents = expectedEvents;
            this.sendExecutor = Executors.newSingleThreadExecutor();
            this.conversationResult = new ArrayBlockingQueue<List<MessageReport>>(1);
        }

        public void close(ActualEvent actual) {
            boolean sendClose = !(actual instanceof ActualEvent.ActualFailure) && !(actual instanceof ActualEvent.ActualClose);
            log.fine("Closing the websocket");
            this.closed = true;
            if (sendClose) {
                this.sendExecutor.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            log.fine("About to send close");
                            webSocket.close(1000, "OK");
                            log.fine("Close sent");
                        }
                        catch (IOException e) {
                            log.warning("Could not close WebSocket");
                        }
                    }
                });
            }
            this.shutDownExecutor();
            try {
                this.conversationResult.put(Collections.unmodifiableList(this.reports));
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public String getSessionId() {
            if (this.sessionId == null) {
                throw new IllegalStateException("sessionId was not initialized yet. A welcome message has probably not arrived yet.");
            }
            return this.sessionId;
        }

        private void handle(ActualEvent actual) {
            log.fine("Received message[" + actual.getIndex() + "] from WebSocket: [" + actual + "]");
            if (this.closed) {
                throw new IllegalStateException("Received [" + (this.inMessageCounter + 1) + "]th message when only [" + this.expectedEvents.size() + "] messages were expected");
            }
            ExpectedEvent expected = this.expectedEvents.get(actual.getIndex());
            MessageReport report = expected.match(actual);
            log.fine(report.toString());
            this.reports.add(report);
            if (report.passed()) {
                expected.scheduleAnswer(actual, this.sendExecutor, this.webSocket);
            } else {
                this.close(actual);
            }
            if (this.inMessageCounter == this.expectedEvents.size()) {
                log.fine("Message[" + actual.getIndex() + "] was the last expected message, sending close.");
                this.close(actual);
            }
        }

        public void onClose(int code, String reason) {
            this.handle(new ActualEvent.ActualClose(this, this.inMessageCounter++, code, reason));
        }

        public void onFailure(IOException e, Response response) {
            this.handle(new ActualEvent.ActualFailure(this, this.inMessageCounter++, e, response));
        }

        public void onMessage(ResponseBody body) throws IOException {
            this.handle(new ActualEvent.ActualMessage(this, this.inMessageCounter++, body));
        }

        public void onOpen(WebSocket webSocket, Response response) {
            log.fine("WebSocket opened");
            this.webSocket = webSocket;
        }

        public void onPong(Buffer payload) {
            log.fine("Got pong [" + payload.readUtf8() + "]");
        }

        private void shutDownExecutor() {
            log.fine("Shutting down the executor");
            try {
                this.sendExecutor.shutdown();
                this.sendExecutor.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            log.fine("Executor shut down");
        }

        public void validate(long timeout) throws Throwable {
            List<MessageReport> finalReports = this.conversationResult.poll(timeout, TimeUnit.MILLISECONDS);
            List<Object> errors = new ArrayList();
            if (finalReports != null) {
                errors = finalReports.stream().filter(r -> !r.passed()).map(MessageReport::getThrowable).collect(Collectors.toList());
            } else {
                log.fine("Timeout: Shutting down the executor");
                this.shutDownExecutor();
                this.closed = true;
                ArrayList<MessageReport> reps = new ArrayList<MessageReport>(this.reports);
                errors.add(new Throwable("Could not get conversation results after " + timeout + "ms. Collected [" + reps.size() + "] reports: [" + reps + "], expected [" + this.expectedEvents.size() + "] events"));
            }
            switch (errors.size()) {
                case 0: {
                    return;
                }
                case 1: {
                    throw (Throwable)errors.get(0);
                }
            }
            Throwable e = (Throwable)errors.get(0);
            throw new AssertionError("[" + errors.size() + "] assertion errors, the first one being [" + e.getMessage() + "]", e);
        }
    }

    public static class ReusableBuffer {
        private final int binaryOffset;
        private final byte[] bytes;
        private boolean lastWasHighSurrogate = false;
        private final String textPart;

        public ReusableBuffer(BufferedSource payload) throws IOException {
            this.bytes = payload.readByteArray();
            payload.close();
            int binOffset = 0;
            StringBuilder sb = new StringBuilder();
            try (InputStreamReader r = new InputStreamReader((InputStream)new ByteArrayInputStream(this.bytes), "utf-8");){
                int c;
                int numberOfOpenedObjects = 0;
                block13: while ((c = ((Reader)r).read()) >= 0) {
                    char ch = (char)c;
                    switch (ch) {
                        case '{': {
                            ++numberOfOpenedObjects;
                            sb.append(ch);
                            binOffset += this.byteLength(ch);
                            continue block13;
                        }
                        case '}': {
                            sb.append(ch);
                            binOffset += this.byteLength(ch);
                            if (--numberOfOpenedObjects != 0) continue block13;
                            break block13;
                        }
                        default: {
                            sb.append(ch);
                            binOffset += this.byteLength(ch);
                            continue block13;
                        }
                    }
                }
                this.textPart = sb.toString();
                this.binaryOffset = binOffset;
            }
        }

        private int byteLength(char ch) {
            if (this.lastWasHighSurrogate) {
                this.lastWasHighSurrogate = false;
                return 2;
            }
            if (ch <= '\u007f') {
                return 1;
            }
            if (ch <= '\u07ff') {
                return 2;
            }
            if (Character.isHighSurrogate(ch)) {
                this.lastWasHighSurrogate = true;
                return 2;
            }
            return 3;
        }

        public Buffer copy() {
            Buffer payloadCopy = new Buffer();
            payloadCopy.write(this.bytes);
            return payloadCopy;
        }

        public int getBinaryLength() {
            return this.bytes.length - this.binaryOffset;
        }

        public InputStream getBinaryPart() {
            if (this.binaryOffset >= this.bytes.length) {
                throw new IllegalStateException("No binary attachment in this buffer");
            }
            return new ByteArrayInputStream(this.bytes, this.binaryOffset, this.bytes.length - this.binaryOffset);
        }

        public String getTextPart() {
            return this.textPart;
        }

        public boolean hasBinaryPart() {
            return this.binaryOffset < this.bytes.length;
        }

        public String toString() {
            return this.getTextPart() + (this.hasBinaryPart() ? " + [" + this.getBinaryLength() + "] bytes of binary attachment" : "");
        }
    }

    public static class PingForeverAnswer
    implements Answer {
        @Override
        public void schedule(final ExecutorService executor, final WebSocket webSocket) {
            Runnable r = new Runnable(){
                private int counter = 0;

                @Override
                public void run() {
                    try {
                        int ping = this.counter++;
                        log.fine("about to sent ping [" + ping + "]");
                        try (Buffer b = new Buffer();){
                            b.writeUtf8(String.valueOf(ping));
                            webSocket.sendPing(b);
                        }
                        try {
                            Thread.sleep(250L);
                            executor.execute(this);
                        }
                        catch (InterruptedException e) {
                            log.fine("Interrupted.");
                        }
                    }
                    catch (IOException e) {
                        log.log(Level.FINE, "Could not ping", e);
                    }
                }
            };
            executor.execute(r);
        }
    }

    public static class PatternMatcher
    extends TypeSafeMatcher<ReusableBuffer>
    implements WebSocketArgumentMatcher<ReusableBuffer> {
        protected final String pattern;

        public PatternMatcher(String pattern) {
            this.pattern = pattern;
        }

        protected Pattern compile(TestListener testListener) {
            String resolvedPattern = testListener == null ? this.pattern : this.resolvePlaceHolders(this.pattern, testListener);
            return Pattern.compile(resolvedPattern);
        }

        public void describeTo(Description description) {
            description.appendText("to match pattern ").appendValue((Object)this.pattern);
        }

        @Override
        public boolean matches(ReusableBuffer actual, TestListener testListener) {
            return this.compile(testListener).matcher(actual.getTextPart()).matches();
        }

        protected boolean matchesSafely(ReusableBuffer item) {
            throw new UnsupportedOperationException();
        }

        private String resolvePlaceHolders(String stringPattern, Object context) {
            String method = "";
            Class<?> ctxClass = context.getClass();
            try {
                String placeholderPattern = "(\\Q{{\\E[[a-zA-Z0-9]| |\t]+?\\Q}}\\E)";
                Pattern rg = Pattern.compile(placeholderPattern);
                Matcher m = rg.matcher(stringPattern);
                while (m.find()) {
                    method = m.group();
                    method = method.replaceAll("\\{", "").replaceAll("\\}", "");
                    method = "get" + method.substring(0, 1).toUpperCase() + method.substring(1);
                    Method getter = ctxClass.getDeclaredMethod(method, new Class[0]);
                    String p = (String)getter.invoke(context, new Object[0]);
                    stringPattern = stringPattern.replaceAll(Pattern.quote(m.group()), p);
                }
                return stringPattern;
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Method " + method + " not found in context " + ctxClass.getName());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Method " + method + " not found in context " + ctxClass.getName());
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Method " + method + " not found in context " + ctxClass.getName());
            }
        }
    }

    public static class MessageReport {
        private final int messageIndex;
        private final Throwable throwable;

        public static MessageReport passed(int index) {
            return new MessageReport(null, index);
        }

        public MessageReport(Throwable throwable, int messageIndex) {
            this.throwable = throwable;
            this.messageIndex = messageIndex;
        }

        public int getMessageIndex() {
            return this.messageIndex;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public boolean passed() {
            return this.throwable == null;
        }

        public String toString() {
            return "Message[" + this.messageIndex + "]: [" + (this.passed() ? "PASSED" : "FAILED - " + this.throwable.getMessage()) + "]";
        }
    }

    public static class MessageAnswer
    implements Answer {
        private final URL binaryAnswer;
        private final long sleepAfterAnswerMs;
        private final String textAnswer;

        public MessageAnswer(String textAnswer) {
            this(textAnswer, null, 0L);
        }

        public MessageAnswer(String textAnswer, URL binaryAnswer, long sleepAfterAnswerMs) {
            this.textAnswer = textAnswer;
            this.binaryAnswer = binaryAnswer;
            this.sleepAfterAnswerMs = sleepAfterAnswerMs;
        }

        @Override
        public void schedule(ExecutorService executor, final WebSocket webSocket) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    block33: {
                        try (Buffer b1 = new Buffer();){
                            if (textAnswer != null) {
                                log.fine("Sending over WebSocket: " + textAnswer);
                                b1.writeUtf8(textAnswer);
                            }
                            if (binaryAnswer != null) {
                                try (InputStream in = binaryAnswer.openStream();){
                                    int b;
                                    while ((b = in.read()) != -1) {
                                        b1.writeByte(b);
                                    }
                                }
                            }
                            RequestBody body = RequestBody.create((MediaType)(binaryAnswer == null ? WebSocket.TEXT : WebSocket.BINARY), (byte[])b1.readByteArray());
                            webSocket.sendMessage(body);
                            if (sleepAfterAnswerMs > 0L) {
                                log.fine("About to sleep for [" + sleepAfterAnswerMs + "] ms");
                                try {
                                    Thread.sleep(sleepAfterAnswerMs);
                                }
                                catch (InterruptedException e) {
                                    log.fine("Interrupted while sleeping for [" + sleepAfterAnswerMs + "] ms");
                                }
                                log.fine("Woke up after [" + sleepAfterAnswerMs + "] ms");
                                break block33;
                            }
                            log.fine("No sleep configured");
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Unable to send message", e);
                        }
                    }
                }
            });
        }
    }

    public static abstract class ExpectedEvent {
        protected final Answer answer;
        protected final Set<Class<? extends ActualEvent>> expectedTypes;

        public static ExpectedAny anyOf(ExpectedEvent ... events) {
            return new ExpectedAny(Arrays.asList(events));
        }

        public ExpectedEvent(Class<? extends ActualEvent> expectedType, Answer answer) {
            this(Collections.singleton(expectedType), answer);
        }

        public ExpectedEvent(Set<Class<? extends ActualEvent>> expectedTypes, Answer answer) {
            this.expectedTypes = expectedTypes;
            this.answer = answer;
        }

        public Set<Class<? extends ActualEvent>> getExpectedTypes() {
            return this.expectedTypes;
        }

        public abstract MessageReport match(ActualEvent var1);

        public void scheduleAnswer(ActualEvent actualEvent, ExecutorService executor, WebSocket webSocket) {
            if (this.answer != null) {
                this.answer.schedule(executor, webSocket);
            } else {
                log.fine("No answer to send for message[" + actualEvent.getIndex() + "]");
            }
        }

        protected MessageReport unexpectedType(ActualEvent actualEvent) {
            String msg = "Expected one of [" + this.getExpectedTypes() + "] found [" + actualEvent.getClass().getName() + "]";
            log.fine(msg);
            return new MessageReport(new IllegalStateException(msg), actualEvent.getIndex());
        }

        public static class ExpectedMessage
        extends ExpectedEvent {
            protected final WebSocketArgumentMatcher<ReusableBuffer> inMessageMatcher;
            private final org.hamcrest.Matcher<MediaType> inTypeMatcher;

            public ExpectedMessage(WebSocketArgumentMatcher<ReusableBuffer> inMessageMatcher, org.hamcrest.Matcher<MediaType> inTypeMatcher, Answer answer) {
                super(ActualEvent.ActualMessage.class, answer);
                this.inMessageMatcher = inMessageMatcher;
                this.inTypeMatcher = inTypeMatcher;
            }

            @Override
            public MessageReport match(ActualEvent actualEvent) {
                if (actualEvent instanceof ActualEvent.ActualMessage) {
                    ActualEvent.ActualMessage msg = (ActualEvent.ActualMessage)actualEvent;
                    ResponseBody body = msg.getBody();
                    try {
                        BufferedSource payload = body.source();
                        MediaType type = body.contentType();
                        ReusableBuffer message = new ReusableBuffer(payload);
                        StringDescription description = new StringDescription();
                        boolean fail = false;
                        if (!this.inMessageMatcher.matches(message, actualEvent.getTestListener())) {
                            description.appendText("Expected: ").appendDescriptionOf(this.inMessageMatcher).appendText("\n     but: ");
                            this.inMessageMatcher.describeMismatch(message, (Description)description);
                            fail = true;
                        }
                        if (!this.inTypeMatcher.matches((Object)type)) {
                            description.appendText("Expected: ").appendDescriptionOf(this.inTypeMatcher).appendText("\n     but: ");
                            this.inTypeMatcher.describeMismatch((Object)type, (Description)description);
                            fail = true;
                        }
                        if (fail) {
                            return new MessageReport((Throwable)((Object)new AssertionError((Object)description.toString())), actualEvent.getIndex());
                        }
                        return MessageReport.passed(actualEvent.getIndex());
                    }
                    catch (IOException e) {
                        return new MessageReport(e, actualEvent.getIndex());
                    }
                }
                return this.unexpectedType(actualEvent);
            }
        }

        public static class ExpectedFailure
        extends ExpectedEvent {
            public static final ExpectedEvent UNAUTHORIZED = new ExpectedFailure(401, "Unauthorized");
            private final int code;
            private final String message;

            public ExpectedFailure(int code, String message) {
                super(ActualEvent.ActualFailure.class, null);
                this.code = code;
                this.message = message;
            }

            @Override
            public MessageReport match(ActualEvent actualEvent) {
                if (actualEvent instanceof ActualEvent.ActualFailure) {
                    ActualEvent.ActualFailure actualFailure = (ActualEvent.ActualFailure)actualEvent;
                    Response response = actualFailure.getResponse();
                    if (this.code == response.code() && Objects.equals(this.message, response.message())) {
                        return MessageReport.passed(actualEvent.getIndex());
                    }
                    Description description = new StringDescription().appendText("Expected a failure with: code ").appendValue((Object)this.code).appendText(" and message ").appendValue((Object)this.message).appendText("\n     but got: code ").appendValue((Object)response.code()).appendText(" and message ").appendValue((Object)response.message());
                    return new MessageReport((Throwable)((Object)new AssertionError((Object)description.toString())), actualEvent.getIndex());
                }
                return this.unexpectedType(actualEvent);
            }
        }

        public static class ExpectedClose
        extends ExpectedEvent {
            private final int code;
            private final String reason;

            public ExpectedClose(int code, String reason) {
                super(ActualEvent.ActualClose.class, null);
                this.code = code;
                this.reason = reason;
            }

            public int getCode() {
                return this.code;
            }

            public String getReason() {
                return this.reason;
            }

            @Override
            public MessageReport match(ActualEvent actualEvent) {
                if (actualEvent instanceof ActualEvent.ActualClose) {
                    ActualEvent.ActualClose actualClose = (ActualEvent.ActualClose)actualEvent;
                    if (this.code == actualClose.getCode() && Objects.equals(this.reason, actualClose.getReason())) {
                        return MessageReport.passed(actualEvent.getIndex());
                    }
                    Description description = new StringDescription().appendText("Expected: code ").appendValue((Object)this.code).appendText(" and reason ").appendValue((Object)this.reason).appendText("\n     but got: code ").appendValue((Object)this.code).appendText(" and reason ").appendValue((Object)this.reason);
                    return new MessageReport((Throwable)((Object)new AssertionError((Object)description.toString())), actualEvent.getIndex());
                }
                return this.unexpectedType(actualEvent);
            }
        }

        public static class ExpectedAny
        extends ExpectedEvent {
            private final List<ExpectedEvent> expectedEvents;

            private static Set<Class<? extends ActualEvent>> collectExpectedTypes(List<ExpectedEvent> expectedEvents) {
                LinkedHashSet<Class<? extends ActualEvent>> result = new LinkedHashSet<Class<? extends ActualEvent>>();
                for (ExpectedEvent expectedEvent : expectedEvents) {
                    result.addAll(expectedEvent.getExpectedTypes());
                }
                return result;
            }

            public ExpectedAny(List<ExpectedEvent> expectedEvents) {
                super(ExpectedAny.collectExpectedTypes(expectedEvents), null);
                this.expectedEvents = expectedEvents;
            }

            @Override
            public MessageReport match(ActualEvent actualEvent) {
                for (ExpectedEvent expectedEvent : this.expectedEvents) {
                    if (!expectedEvent.getExpectedTypes().contains(actualEvent.getClass())) continue;
                    return expectedEvent.match(actualEvent);
                }
                return this.unexpectedType(actualEvent);
            }

            @Override
            public void scheduleAnswer(ActualEvent actualEvent, ExecutorService executor, WebSocket webSocket) {
                for (ExpectedEvent expectedEvent : this.expectedEvents) {
                    if (!expectedEvent.getExpectedTypes().contains(actualEvent.getClass())) continue;
                    expectedEvent.scheduleAnswer(actualEvent, executor, webSocket);
                }
            }
        }
    }

    public static class Builder {
        private String authentication = AbstractCommandITest.authHeader;
        private final List<ExpectedEvent> expectedEvents = new ArrayList<ExpectedEvent>();
        private String url;

        public Builder authentication(String authentication) {
            this.authentication = authentication;
            return this;
        }

        public TestWebSocketClient build() {
            Request.Builder rb = new Request.Builder().url(this.url);
            if (this.authentication != null) {
                rb.addHeader("Authorization", this.authentication);
            }
            Request request = rb.build();
            TestListener listener = new TestListener(Collections.unmodifiableList(this.expectedEvents));
            return new TestWebSocketClient(request, listener);
        }

        public Builder expectBinary(String textPattern, TypeSafeMatcher<InputStream> binaryMatcher) {
            ExpectedEvent.ExpectedMessage expectedEvent = new ExpectedEvent.ExpectedMessage(new BinaryAwareMatcher(textPattern, binaryMatcher), (org.hamcrest.Matcher<MediaType>)CoreMatchers.equalTo((Object)WebSocket.BINARY), null);
            this.expectedEvents.add(expectedEvent);
            return this;
        }

        public Builder expectGenericSuccess(String feedId) {
            ExpectedEvent.ExpectedMessage expectedEvent = new ExpectedEvent.ExpectedMessage(new PatternMatcher("\\QGenericSuccessResponse={\"message\":\"The request has been forwarded to feed [" + feedId + "] (\\E.*"), (org.hamcrest.Matcher<MediaType>)CoreMatchers.equalTo((Object)WebSocket.TEXT), null);
            this.expectedEvents.add(expectedEvent);
            return this;
        }

        public Builder expectMessage(ExpectedEvent expectedEvent) {
            this.expectedEvents.add(expectedEvent);
            return this;
        }

        public Builder expectRegex(String expectedRegex) {
            ExpectedEvent.ExpectedMessage expectedEvent = new ExpectedEvent.ExpectedMessage(new PatternMatcher(expectedRegex), (org.hamcrest.Matcher<MediaType>)CoreMatchers.equalTo((Object)WebSocket.TEXT), null);
            this.expectedEvents.add(expectedEvent);
            return this;
        }

        public Builder expectText(String expectedTextMessage) {
            return this.expectText(expectedTextMessage, null);
        }

        public Builder expectText(String expectedTextMessage, Answer messageAnswer) {
            ExpectedEvent.ExpectedMessage expectedEvent = new ExpectedEvent.ExpectedMessage(new PatternMatcher("\\Q" + expectedTextMessage + "\\E.*"), (org.hamcrest.Matcher<MediaType>)CoreMatchers.equalTo((Object)WebSocket.TEXT), messageAnswer);
            this.expectedEvents.add(expectedEvent);
            return this;
        }

        public Builder expectWelcome(MessageAnswer messageAnswer) {
            ExpectedEvent.ExpectedMessage expectedEvent = new ExpectedEvent.ExpectedMessage(new WelcomeMatcher(), (org.hamcrest.Matcher<MediaType>)CoreMatchers.equalTo((Object)WebSocket.TEXT), messageAnswer);
            this.expectedEvents.add(expectedEvent);
            return this;
        }

        public Builder expectWelcome(String answer) {
            return this.expectWelcome(new MessageAnswer(answer));
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }
    }

    public static class BinaryAwareMatcher
    extends PatternMatcher {
        private TypeSafeMatcher<InputStream> binaryMatcher;

        public BinaryAwareMatcher(String pattern, TypeSafeMatcher<InputStream> binaryMatcher) {
            super(pattern);
            this.binaryMatcher = binaryMatcher;
        }

        @Override
        public void describeTo(Description description) {
            super.describeTo(description);
            description.appendDescriptionOf(this.binaryMatcher);
        }

        @Override
        public boolean matches(ReusableBuffer actual, TestListener testListener) {
            return super.matches(actual, testListener) && this.binaryMatcher.matches((Object)actual.getBinaryPart());
        }
    }

    public static interface Answer {
        public void schedule(ExecutorService var1, WebSocket var2);
    }

    public static abstract class ActualEvent {
        private final int index;
        private final TestListener testListener;

        public ActualEvent(TestListener testListener, int index) {
            this.testListener = testListener;
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public TestListener getTestListener() {
            return this.testListener;
        }

        public static class ActualOpen
        extends ActualEvent {
            private final Response response;
            private final WebSocket webSocket;

            public ActualOpen(TestListener testListener, int index, WebSocket webSocket, Response response) {
                super(testListener, index);
                this.webSocket = webSocket;
                this.response = response;
            }

            public Response getResponse() {
                return this.response;
            }

            public WebSocket getWebSocket() {
                return this.webSocket;
            }
        }

        public static class ActualMessage
        extends ActualEvent {
            private final ResponseBody body;

            public ActualMessage(TestListener testListener, int index, ResponseBody body) {
                super(testListener, index);
                this.body = body;
            }

            public ResponseBody getBody() {
                return this.body;
            }
        }

        public static class ActualFailure
        extends ActualEvent {
            private final IOException exception;
            private final Response response;

            public ActualFailure(TestListener testListener, int index, IOException exception, Response response) {
                super(testListener, index);
                this.exception = exception;
                this.response = response;
            }

            public IOException getException() {
                return this.exception;
            }

            public Response getResponse() {
                return this.response;
            }
        }

        public static class ActualClose
        extends ActualEvent {
            private final int code;
            private final String reason;

            public ActualClose(TestListener testListener, int index, int code, String reason) {
                super(testListener, index);
                this.code = code;
                this.reason = reason;
            }

            public int getCode() {
                return this.code;
            }

            public String getReason() {
                return this.reason;
            }
        }
    }
}

