/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.cmdgw.ws.test;

import com.squareup.okhttp.Credentials;
import org.hawkular.cmdgw.ws.test.AbstractCommandITest;
import org.hawkular.cmdgw.ws.test.ClientConfig;
import org.hawkular.cmdgw.ws.test.TestWebSocketClient;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.testng.annotations.Test;

public class EchoCommandITest
extends AbstractCommandITest {
    public static final String GROUP = "EchoCommandITest";
    private static final String echoRequestTemplate = "EchoRequest={\"authentication\": " + ClientConfig.authentication + ", \"echoMessage\": \"%s\"}";
    private static final String echoResponseTemplate = "EchoResponse={\"reply\":\"ECHO [%s]\"}";

    @RunAsClient
    @Test(groups={"EchoCommandITest"})
    public void testEcho() throws Throwable {
        try (TestWebSocketClient testClient = TestWebSocketClient.builder().url(ClientConfig.baseGwUri + "/ui/ws").expectWelcome(String.format(echoRequestTemplate, "Yodel Ay EEE Oooo")).expectText(String.format(echoResponseTemplate, "Yodel Ay EEE Oooo"), TestWebSocketClient.Answer.CLOSE).expectClose().build();){
            testClient.validate(10000L);
        }
    }

    @RunAsClient
    @Test(groups={"EchoCommandITest"})
    public void testWithoutAuth() throws Throwable {
        try (TestWebSocketClient testClient = TestWebSocketClient.builder().url(ClientConfig.baseGwUri + "/ui/ws").authentication(null).expectMessage(TestWebSocketClient.ExpectedEvent.ExpectedFailure.UNAUTHORIZED).build();){
            testClient.validate(10000L);
        }
    }

    @RunAsClient
    @Test(groups={"EchoCommandITest"})
    public void testBadPassword() throws Throwable {
        try (TestWebSocketClient testClient = TestWebSocketClient.builder().url(ClientConfig.baseGwUri + "/ui/ws").authentication(Credentials.basic((String)ClientConfig.testUser, (String)"bad password")).expectMessage(TestWebSocketClient.ExpectedEvent.ExpectedFailure.UNAUTHORIZED).build();){
            testClient.validate(10000L);
        }
    }

    @RunAsClient
    @Test(groups={"EchoCommandITest"})
    public void testBadUserAndPassword() throws Throwable {
        try (TestWebSocketClient testClient = TestWebSocketClient.builder().url(ClientConfig.baseGwUri + "/ui/ws").authentication(Credentials.basic((String)"baduser", (String)"bad password")).expectMessage(TestWebSocketClient.ExpectedEvent.ExpectedFailure.UNAUTHORIZED).build();){
            testClient.validate(10000L);
        }
    }
}

