/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.cmdgw.command.bus;

import javax.websocket.Session;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.cmdgw.api.UiSessionDestination;
import org.hawkular.cmdgw.command.bus.BusCommand;
import org.hawkular.cmdgw.command.bus.BusCommandContext;
import org.hawkular.cmdgw.command.ws.server.WebSocketHelper;
import org.hawkular.cmdgw.log.GatewayLoggers;
import org.hawkular.cmdgw.log.MsgLogger;

public class UiSessionDestinationBusCommand
implements BusCommand<UiSessionDestination> {
    private static final MsgLogger log = GatewayLoggers.getLogger(UiSessionDestinationBusCommand.class);

    public void execute(BasicMessageWithExtraData<UiSessionDestination> message, BusCommandContext context) throws Exception {
        UiSessionDestination request = (UiSessionDestination)message.getBasicMessage();
        String destinationSessionId = request.getDestinationSessionId();
        if (destinationSessionId == null) {
            throw new IllegalStateException(request.getClass().getName() + ".destinationSessionId must not be null");
        }
        log.tracef("[%s] is about to execute the request [%s] ", (Object)this.getClass().getName(), (Object)request);
        Session session = context.getConnectedUIClients().getSession(destinationSessionId);
        if (session == null) {
            throw new Exception("No such sessionId [" + destinationSessionId + "]");
        }
        new WebSocketHelper().sendSync(session, message);
    }
}

