/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.cmdgw.command.ws;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import javax.websocket.CloseReason;
import javax.websocket.Session;
import org.hawkular.cmdgw.command.ws.WsSessionListener;
import org.hawkular.cmdgw.command.ws.WsSessions;
import org.hawkular.cmdgw.log.GatewayLoggers;
import org.hawkular.cmdgw.log.MsgLogger;

public class WsSessions {
    private static final MsgLogger log = GatewayLoggers.getLogger(WsSessions.class);
    private final String endpoint;
    private final ReadWriteLock sessionsLock = new ReentrantReadWriteLock(true);
    private final Lock sessionsLockRead = this.sessionsLock.readLock();
    private final Lock sessionsLockWrite = this.sessionsLock.writeLock();
    private final Map<String, SessionEntry> sessions = new HashMap();
    private final List<BiFunction<String, Session, WsSessionListener>> wsSessionListenerProducers = new CopyOnWriteArrayList();

    public WsSessions(String endpoint) {
        this.endpoint = endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSession(String key, Session newSession) {
        SessionEntry newEntry = this.createSessionEntry(key, newSession);
        SessionEntry oldEntry = null;
        this.sessionsLockWrite.lock();
        try {
            oldEntry = this.sessions.putIfAbsent(key, newEntry);
        }
        finally {
            this.sessionsLockWrite.unlock();
        }
        if (oldEntry == null) {
            log.debugf("A WebSocket session [%s] of [%s] has been added. The endpoint has now [%d] sessions", (Object)key, (Object)this.endpoint, (Object)this.sessions.size());
            newEntry.added();
        } else {
            try {
                log.errorClosingDuplicateWsSession(key, this.endpoint);
                newSession.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.VIOLATED_POLICY, "Cannot have multiple WebSocket sessions open, the new one will be closed"));
            }
            catch (Exception e) {
                log.errorCannotCloseDuplicateWsSession(key, this.endpoint, (Throwable)e);
            }
        }
        return oldEntry == null;
    }

    public void addWsSessionListenerProducer(BiFunction<String, Session, WsSessionListener> wsSessionListenerProducer) {
        this.wsSessionListenerProducers.add(wsSessionListenerProducer);
    }

    private SessionEntry createSessionEntry(String sessionKey, Session session) {
        ArrayList<WsSessionListener> sessionListeners = new ArrayList<WsSessionListener>();
        for (BiFunction producer : this.wsSessionListenerProducers) {
            WsSessionListener sessionListener = (WsSessionListener)producer.apply(sessionKey, session);
            if (sessionListener == null) continue;
            sessionListeners.add(sessionListener);
        }
        return new SessionEntry(session, sessionListeners, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession(String key) {
        this.sessionsLockRead.lock();
        try {
            SessionEntry entry = (SessionEntry)this.sessions.get(key);
            Session session = entry != null ? entry.getSession() : null;
            return session;
        }
        finally {
            this.sessionsLockRead.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(String key, Session doomedSession) {
        SessionEntry removedEntry = null;
        this.sessionsLockWrite.lock();
        try {
            if (doomedSession == null) {
                removedEntry = (SessionEntry)this.sessions.remove(key);
            } else {
                SessionEntry existingEntry = (SessionEntry)this.sessions.get(key);
                if (existingEntry != null && existingEntry.getSession().getId().equals(doomedSession.getId())) {
                    removedEntry = (SessionEntry)this.sessions.remove(key);
                }
            }
            if (removedEntry != null) {
                removedEntry.removed();
                log.debugf("WebSocket Session [%s] of [%s] with key [%s] has been removed. The endpoint has now [%d] sessions", new Object[]{removedEntry.getSession().getId(), this.endpoint, key, this.sessions.size()});
            }
        }
        finally {
            this.sessionsLockWrite.unlock();
        }
    }

    public void destroy() {
        this.sessionsLockWrite.lock();
        try {
            log.debugf("Destroying [%s] of [%s]. About to call remove listeners on [%d] sessions.", (Object)this.getClass().getName(), (Object)this.endpoint, (Object)this.sessions.size());
            for (SessionEntry entry : this.sessions.values()) {
                entry.removed();
            }
            this.sessions.clear();
        }
        catch (Throwable t) {
            log.couldNotDestroy(this.getClass().getName(), this.endpoint, t);
        }
        finally {
            this.sessionsLockWrite.unlock();
        }
    }

    public void removeWsSessionListenerProducer(BiFunction<String, Session, WsSessionListener> wsSessionListenerProducer) {
        this.wsSessionListenerProducers.remove(wsSessionListenerProducer);
    }
}

