/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.cmdgw.command.ws.server;

import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.ConnectionContextFactory;
import org.hawkular.bus.common.Endpoint;
import org.hawkular.bus.common.MessageId;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.producer.ProducerConnectionContext;
import org.hawkular.cmdgw.Constants;
import org.hawkular.cmdgw.api.FeedWebSocketClosedEvent;
import org.hawkular.cmdgw.command.ws.WsCommandContext;
import org.hawkular.cmdgw.command.ws.server.AbstractGatewayWebSocket;
import org.hawkular.cmdgw.log.GatewayLoggers;
import org.hawkular.cmdgw.log.MsgLogger;

@ServerEndpoint(value="/feed/{feedId}")
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class FeedWebSocket
extends AbstractGatewayWebSocket {
    public static final String ENDPOINT = "/feed/{feedId}";
    private static MsgLogger log = GatewayLoggers.getLogger(FeedWebSocket.class);

    public FeedWebSocket() {
        super(ENDPOINT);
    }

    @OnOpen
    public void feedSessionOpen(Session session, @PathParam(value="feedId") String feedId) {
        log.infoWsSessionOpened(feedId, this.endpoint);
        this.wsEndpoints.getFeedSessions().addSession(feedId, session);
    }

    @OnClose
    public void feedSessionClose(Session session, CloseReason reason, @PathParam(value="feedId") String feedId) {
        log.infoWsSessionClosed(feedId, this.endpoint, reason);
        WsCommandContext context = this.commandContextFactory.newCommandContext(session);
        try (ConnectionContextFactory ccf = new ConnectionContextFactory(context.getConnectionFactory());){
            Endpoint endpoint = Constants.HAWKULAR_TOPIC;
            ProducerConnectionContext pcc = ccf.createProducerConnectionContext(endpoint);
            FeedWebSocketClosedEvent message = new FeedWebSocketClosedEvent();
            message.setFeedId(feedId);
            message.setReason(reason.getReasonPhrase());
            message.setCode(String.valueOf(reason.getCloseCode().getCode()));
            MessageId messageId = new MessageProcessor().send(pcc, (BasicMessage)message);
        }
        catch (Exception e) {
            log.errorFailedSendFeedClosedEvent((Throwable)e, feedId, reason.getReasonPhrase(), String.valueOf(reason.getCloseCode()));
        }
        this.wsEndpoints.getFeedSessions().removeSession(feedId, session);
    }
}

