/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.cmdgw.command.ws;

import java.util.Collections;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.ConnectionContextFactory;
import org.hawkular.bus.common.Endpoint;
import org.hawkular.bus.common.MessageId;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.producer.ProducerConnectionContext;
import org.hawkular.cmdgw.Constants;
import org.hawkular.cmdgw.api.GenericSuccessResponse;
import org.hawkular.cmdgw.api.ResourceDestination;
import org.hawkular.cmdgw.command.ws.WsCommand;
import org.hawkular.cmdgw.command.ws.WsCommandContext;
import org.hawkular.cmdgw.command.ws.server.WebSocketHelper;
import org.hawkular.cmdgw.log.GatewayLoggers;
import org.hawkular.cmdgw.log.MsgLogger;

public class ResourceDestinationWsCommand
implements WsCommand<ResourceDestination> {
    private static final MsgLogger log = GatewayLoggers.getLogger(ResourceDestinationWsCommand.class);

    public void execute(BasicMessageWithExtraData<ResourceDestination> message, WsCommandContext context) throws Exception {
        ResourceDestination request = (ResourceDestination)message.getBasicMessage();
        String feedId = request.getFeedId();
        String resourceId = request.getResourceId();
        if (feedId == null || resourceId == null) {
            throw new IllegalStateException(request.getClass().getName() + ".{feedId, resourceId} must not be null");
        }
        log.tracef("[%s] is about to execute the request [%s] ", (Object)this.getClass().getName(), (Object)request);
        try (ConnectionContextFactory ccf = new ConnectionContextFactory(context.getConnectionFactory());){
            Endpoint endpoint = Constants.FEED_COMMAND_QUEUE;
            ProducerConnectionContext pcc = ccf.createProducerConnectionContext(endpoint);
            MessageId mid = new MessageProcessor().send(pcc, message, Collections.singletonMap("feedId", feedId));
            log.debugf("Message [%s] forwarded to bus endpoint [%s]", (Object)request.getClass().getName(), (Object)endpoint.getName());
            GenericSuccessResponse response = new GenericSuccessResponse();
            response.setMessage("The request has been forwarded to feed [" + feedId + "] (MessageId=" + mid + ")");
            BasicMessageWithExtraData result = new BasicMessageWithExtraData((BasicMessage)response, null);
            new WebSocketHelper().sendSync(context.getSession(), result);
        }
    }
}

