/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.commons.rest.status;

import com.wordnik.swagger.annotations.Api;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.hawkular.commons.rest.status.ManifestUtil;
import org.hawkular.commons.rest.status.RestStatusInfo;
import org.hawkular.commons.rest.status.log.MsgLogger;
import org.hawkular.commons.rest.status.log.RestStatusLoggers;

@Path(value="/status")
@Api(value="/status", description="Status of the component service.")
@ApplicationScoped
public class RestStatusHandler {
    private static final MsgLogger log = RestStatusLoggers.getLogger(RestStatusHandler.class);
    @Inject
    @RestStatusInfo
    private Instance<Map<String, String>> details;
    private final Object baseStatusLock = new Object();
    private volatile Map<String, String> baseStatus;

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response status(@Context ServletContext servletContext) {
        Map<String, String> status;
        if (this.details.isUnsatisfied()) {
            status = this.getBaseStatus(servletContext);
        } else {
            status = new LinkedHashMap<String, String>(this.getBaseStatus(servletContext));
            for (Map details : this.details) {
                status.putAll(details);
            }
        }
        return Response.ok(status).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getBaseStatus(ServletContext servletContext) {
        if (this.baseStatus == null) {
            Object object = this.baseStatusLock;
            synchronized (object) {
                if (this.baseStatus == null) {
                    try {
                        this.baseStatus = Collections.unmodifiableMap(ManifestUtil.getVersionAttributes(servletContext));
                    }
                    catch (IOException e) {
                        log.errorFailedToReadManifest(servletContext.getContextPath(), e);
                        this.baseStatus = Collections.emptyMap();
                    }
                }
            }
        }
        return this.baseStatus;
    }
}

