/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular;

import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import java.lang.management.ManagementFactory;
import javax.management.ObjectName;
import org.hawkular.HandlersManager;
import org.hawkular.HawkularServerMBean;
import org.hawkular.commons.log.MsgLogger;
import org.hawkular.commons.log.MsgLogging;
import org.hawkular.commons.properties.HawkularProperties;

public class HawkularServer
implements HawkularServerMBean {
    private static final MsgLogger log = MsgLogging.getMsgLogger(HawkularServer.class);
    private static final String BIND_ADDRESS = "hawkular.bind-address";
    private static final String BIND_ADDRESS_DEFAULT = "127.0.0.1";
    private static final String PORT = "hawkular.port";
    private static final String PORT_DEFAULT = "8080";
    private static final String JMX_NAME = "org.hawkular:name=HawkularServer";
    private static final String REQUEST_COMPRESSION = "hawkular.request-compression";
    private static final String REQUEST_COMPRESSION_DEFAULT = "true";
    private Vertx vertx;
    private HttpServer server;
    private HandlersManager handlers;

    public void start() {
        long start = System.currentTimeMillis();
        String bindAdress = HawkularProperties.getProperty((String)BIND_ADDRESS, (String)BIND_ADDRESS_DEFAULT);
        Integer port = Integer.valueOf(HawkularProperties.getProperty((String)PORT, (String)PORT_DEFAULT));
        boolean requestCompression = Boolean.valueOf(HawkularProperties.getProperty((String)REQUEST_COMPRESSION, (String)REQUEST_COMPRESSION_DEFAULT));
        try {
            this.vertx = Vertx.vertx();
            this.handlers = new HandlersManager(this.vertx);
            this.handlers.start();
            HttpServerOptions serverOptions = new HttpServerOptions();
            serverOptions.setCompressionSupported(requestCompression);
            this.server = this.vertx.createHttpServer(serverOptions);
            log.infof("Starting Server at http://%s:%s in [%s ms] ", (Object)bindAdress, (Object)port, (Object)(System.currentTimeMillis() - start));
            this.server.requestHandler(this.handlers::handle).listen(port.intValue(), bindAdress);
        }
        catch (Exception e) {
            log.error((Object)e);
            log.error((Object)"Forcing exit");
            this.handlers.stop();
            this.server.close();
            System.exit(1);
        }
    }

    @Override
    public String getStatus() {
        return this.server != null ? "STARTED" : "STOPPED";
    }

    @Override
    public void stop() {
        log.info((Object)"Stopping Server");
        this.handlers.stop();
        this.server.close();
        log.info((Object)"Server stopped");
        System.exit(0);
    }

    public static void registerMBean(HawkularServer server) {
        try {
            ObjectName jmxName = new ObjectName(JMX_NAME);
            ManagementFactory.getPlatformMBeanServer().registerMBean(server, jmxName);
        }
        catch (Exception exception) {
            log.error((Object)"Unable to register JMX Bean");
        }
    }

    public static void main(String[] args) {
        HawkularServer server = new HawkularServer();
        HawkularServer.registerMBean(server);
        server.start();
    }
}

