/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate5.management;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.persistence.EntityManagerFactory;
import org.hibernate.SessionFactory;
import org.hibernate.stat.SecondLevelCacheStatistics;
import org.hibernate.stat.Statistics;
import org.jboss.as.jpa.hibernate5.management.HibernateAbstractStatistics;
import org.jipijapa.management.spi.EntityManagerFactoryAccess;
import org.jipijapa.management.spi.Operation;
import org.jipijapa.management.spi.PathAddress;

public class HibernateEntityCacheStatistics
extends HibernateAbstractStatistics {
    public static final String ATTRIBUTE_ENTITY_CACHE_REGION_NAME = "entity-cache-region-name";
    public static final String OPERATION_SECOND_LEVEL_CACHE_HIT_COUNT = "second-level-cache-hit-count";
    public static final String OPERATION_SECOND_LEVEL_CACHE_MISS_COUNT = "second-level-cache-miss-count";
    public static final String OPERATION_SECOND_LEVEL_CACHE_PUT_COUNT = "second-level-cache-put-count";
    public static final String OPERATION_SECOND_LEVEL_CACHE_COUNT_IN_MEMORY = "second-level-cache-count-in-memory";
    public static final String OPERATION_SECOND_LEVEL_CACHE_SIZE_IN_MEMORY = "second-level-cache-size-in-memory";
    private Operation getEntityCacheRegionName = new Operation(){

        public Object invoke(Object ... args) {
            return HibernateEntityCacheStatistics.this.getStatisticName(args);
        }
    };
    private Operation entityCacheHitCount = new Operation(){

        public Object invoke(Object ... args) {
            SecondLevelCacheStatistics statistics = HibernateEntityCacheStatistics.this.getStatistics(HibernateEntityCacheStatistics.this.getEntityManagerFactoryAccess(args), HibernateEntityCacheStatistics.this.getPathAddress(args));
            return statistics != null ? statistics.getHitCount() : 0L;
        }
    };
    private Operation entityCacheMissCount = new Operation(){

        public Object invoke(Object ... args) {
            SecondLevelCacheStatistics statistics = HibernateEntityCacheStatistics.this.getStatistics(HibernateEntityCacheStatistics.this.getEntityManagerFactoryAccess(args), HibernateEntityCacheStatistics.this.getPathAddress(args));
            return statistics != null ? statistics.getMissCount() : 0L;
        }
    };
    private Operation entityCachePutCount = new Operation(){

        public Object invoke(Object ... args) {
            SecondLevelCacheStatistics statistics = HibernateEntityCacheStatistics.this.getStatistics(HibernateEntityCacheStatistics.this.getEntityManagerFactoryAccess(args), HibernateEntityCacheStatistics.this.getPathAddress(args));
            return statistics != null ? statistics.getPutCount() : 0L;
        }
    };
    private Operation entityCacheSizeInMemory = new Operation(){

        public Object invoke(Object ... args) {
            SecondLevelCacheStatistics statistics = HibernateEntityCacheStatistics.this.getStatistics(HibernateEntityCacheStatistics.this.getEntityManagerFactoryAccess(args), HibernateEntityCacheStatistics.this.getPathAddress(args));
            return statistics != null ? statistics.getSizeInMemory() : 0L;
        }
    };
    private Operation entityCacheCountInMemory = new Operation(){

        public Object invoke(Object ... args) {
            SecondLevelCacheStatistics statistics = HibernateEntityCacheStatistics.this.getStatistics(HibernateEntityCacheStatistics.this.getEntityManagerFactoryAccess(args), HibernateEntityCacheStatistics.this.getPathAddress(args));
            return statistics != null ? statistics.getElementCountInMemory() : 0L;
        }
    };

    public HibernateEntityCacheStatistics() {
        this.getOperations().put(ATTRIBUTE_ENTITY_CACHE_REGION_NAME, this.getEntityCacheRegionName);
        this.getTypes().put(ATTRIBUTE_ENTITY_CACHE_REGION_NAME, String.class);
        this.getOperations().put(OPERATION_SECOND_LEVEL_CACHE_HIT_COUNT, this.entityCacheHitCount);
        this.getTypes().put(OPERATION_SECOND_LEVEL_CACHE_HIT_COUNT, Long.class);
        this.getOperations().put(OPERATION_SECOND_LEVEL_CACHE_MISS_COUNT, this.entityCacheMissCount);
        this.getTypes().put(OPERATION_SECOND_LEVEL_CACHE_MISS_COUNT, Long.class);
        this.getOperations().put(OPERATION_SECOND_LEVEL_CACHE_PUT_COUNT, this.entityCachePutCount);
        this.getTypes().put(OPERATION_SECOND_LEVEL_CACHE_PUT_COUNT, Long.class);
        this.getOperations().put(OPERATION_SECOND_LEVEL_CACHE_COUNT_IN_MEMORY, this.entityCacheCountInMemory);
        this.getTypes().put(OPERATION_SECOND_LEVEL_CACHE_COUNT_IN_MEMORY, Long.class);
        this.getOperations().put(OPERATION_SECOND_LEVEL_CACHE_SIZE_IN_MEMORY, this.entityCacheSizeInMemory);
        this.getTypes().put(OPERATION_SECOND_LEVEL_CACHE_SIZE_IN_MEMORY, Long.class);
    }

    public Collection<String> getDynamicChildrenNames(EntityManagerFactoryAccess entityManagerFactoryLookup, PathAddress pathAddress) {
        Statistics stats = this.getBaseStatistics(entityManagerFactoryLookup.entityManagerFactory(pathAddress.getValue("hibernate-persistence-unit")));
        if (stats == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(Arrays.asList(stats.getEntityNames()));
    }

    private Statistics getBaseStatistics(EntityManagerFactory entityManagerFactory) {
        if (entityManagerFactory == null) {
            return null;
        }
        SessionFactory sessionFactory = (SessionFactory)entityManagerFactory.unwrap(SessionFactory.class);
        if (sessionFactory != null) {
            return sessionFactory.getStatistics();
        }
        return null;
    }

    SecondLevelCacheStatistics getStatistics(EntityManagerFactoryAccess entityManagerFactoryaccess, PathAddress pathAddress) {
        String scopedPersistenceUnitName = pathAddress.getValue("hibernate-persistence-unit");
        SessionFactory sessionFactory = (SessionFactory)entityManagerFactoryaccess.entityManagerFactory(scopedPersistenceUnitName).unwrap(SessionFactory.class);
        if (sessionFactory != null) {
            return sessionFactory.getStatistics().getSecondLevelCacheStatistics(scopedPersistenceUnitName + "." + pathAddress.getValue("entity-cache"));
        }
        return null;
    }
}

