/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tck.report;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.tck.config.RuntimeProperties;
import org.hibernate.tck.config.Strings;
import org.hibernate.tck.report.AuditAssertion;
import org.hibernate.tck.report.AuditParser;
import org.hibernate.tck.report.SpecReference;

public class CoverageReport {
    public static final String FISHEYE_BASE_URL_PROPERTY = "fisheye_base_url";
    public static final String SVN_BASE_URL_PROPERTY = "svn_base_url";
    private static final Pattern PATTERN_BOLD = Pattern.compile("([_][^_]*[_])");
    private static final Pattern PATTERN_STRIKETHROUGH = Pattern.compile("([~][^~]*[~])");
    private static final String REPORT_FILE_NAME = "coverage.html";
    private static final String COLOUR_SHADE_GREEN = "#ddffdd";
    private static final String COLOUR_SHADE_RED = "#ffdddd";
    private static final String COLOUR_SHADE_BLUE = "#80d1ff";
    private static final String COLOUR_SHADE_ORANGE = "#ffcc33";
    private final Map<String, List<SpecReference>> references = new HashMap<String, List<SpecReference>>();
    private AuditParser auditParser;
    private File imageSrcDir;
    private File imageTargetDir;
    private RuntimeProperties properties;
    private String fisheyeBaseUrl = null;
    private String svnBaseUrl = null;
    private List<SpecReference> unmatched;
    private int failThreshold;
    private int passThreshold;
    private Set<String> unimplementedTestGroups;

    public CoverageReport(List<SpecReference> references, AuditParser auditParser, File imageSrcDir) {
        for (SpecReference ref : references) {
            if (!this.references.containsKey(ref.getSection())) {
                this.references.put(ref.getSection(), new ArrayList());
            }
            this.references.get(ref.getSection()).add(ref);
        }
        this.auditParser = auditParser;
        this.imageSrcDir = imageSrcDir;
        this.properties = new RuntimeProperties();
        try {
            this.fisheyeBaseUrl = this.properties.getStringValue(FISHEYE_BASE_URL_PROPERTY, null, false);
            if (!this.fisheyeBaseUrl.endsWith("/")) {
                this.fisheyeBaseUrl = this.fisheyeBaseUrl + "/";
            }
            this.svnBaseUrl = this.properties.getStringValue(SVN_BASE_URL_PROPERTY, null, false);
            if (!this.svnBaseUrl.endsWith("/")) {
                this.svnBaseUrl = this.svnBaseUrl + "/";
            }
            this.passThreshold = this.properties.getIntValue("pass_threshold", 75, false);
            this.failThreshold = this.properties.getIntValue("fail_threshold", 50, false);
            String unimplemented = this.properties.getStringValue("unimplemented_test_groups", null, false);
            if (unimplemented != null) {
                String[] parts = unimplemented.split(",");
                this.unimplementedTestGroups = new HashSet<String>();
                for (String part : parts) {
                    if ("".equals(part.trim())) continue;
                    this.unimplementedTestGroups.add(part.trim());
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public void generate(File outputDir) throws IOException {
        File coverageFile = new File(outputDir, REPORT_FILE_NAME);
        FileOutputStream out = new FileOutputStream(coverageFile);
        this.imageTargetDir = new File(outputDir, "/images");
        if (!this.imageTargetDir.exists()) {
            this.imageTargetDir.mkdirs();
        }
        this.calculateUnmatched();
        this.writeHeader(out);
        this.writeContents(out);
        this.writeChapterSummary(out);
        this.writeSectionSummary(out);
        this.writeCoverage(out);
        this.writeUnmatched(out);
        this.writeFooter(out);
    }

    private void calculateUnmatched() {
        this.unmatched = new ArrayList<SpecReference>();
        for (String sectionId : this.references.keySet()) {
            for (SpecReference ref : this.references.get(sectionId)) {
                if (this.auditParser.hasAssertion(ref.getSection(), ref.getAssertion())) continue;
                this.unmatched.add(ref);
            }
        }
    }

    private void writeHeader(OutputStream out) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\"\n");
        sb.append("\"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\n");
        sb.append("<html>\n");
        sb.append("<head><title>JSR-299 TCK Coverage Report</title>\n");
        sb.append("<style type=\"text/css\">\n");
        sb.append("  body {\n");
        sb.append("   font-family: verdana, arial, sans-serif;\n");
        sb.append("   font-size: 11px; }\n");
        sb.append("  .code {\n");
        sb.append("    float: left;\n");
        sb.append("    font-weight: bold;\n");
        sb.append("    width: 50px;\n");
        sb.append("    margin-top: 0px;\n");
        sb.append("    height: 100%; }\n");
        sb.append("   a.external, a.external:visited, a.external:hover {\n");
        sb.append("    color: #0000ff;\n");
        sb.append("    font-size: 9px;\n");
        sb.append("    font-style: normal;\n");
        sb.append("    padding-left: 2px;\n");
        sb.append("    margin-left: 6px;\n");
        sb.append("    margin-right: 6px;\n");
        sb.append("    padding-right: 2px; }\n");
        sb.append("  .results {\n");
        sb.append("    margin-left: 50px; }\n");
        sb.append("  .description {\n");
        sb.append("    margin-top: 2px;\n");
        sb.append("    margin-bottom: 2px; }\n");
        sb.append("  .sectionHeader {\n");
        sb.append("    border-bottom: 1px solid #cccccc;\n");
        sb.append("    margin-top: 8px;\n");
        sb.append("    font-weight: bold; }\n");
        sb.append("  .packageName {\n");
        sb.append("   color: #999999;\n");
        sb.append("   font-size: 9px;\n");
        sb.append("   font-weight: bold; }\n");
        sb.append("  .embeddedImage {\n");
        sb.append("   margin: 6px;\n");
        sb.append("   border: 1px solid black;\n");
        sb.append("   float: right; }\n");
        sb.append("  .coverage {\n");
        sb.append("   clear: both; }\n");
        sb.append("  .noCoverage {\n");
        sb.append("   margin-top: 2px;\n");
        sb.append("   margin-bottom: 2px;\n");
        sb.append("   font-weight: bold;\n");
        sb.append("   font-style: italic;\n");
        sb.append("   color: #ff0000; }\n");
        sb.append("  .coverageHeader {\n");
        sb.append("   font-weight: bold;\n");
        sb.append("   text-decoration: underline;\n");
        sb.append("   margin-top: 2px;\n");
        sb.append("   margin-bottom: 2px; }\n");
        sb.append("  .coverageMethod {\n");
        sb.append("   font-style: italic; }\n");
        sb.append("  .highlight {\n");
        sb.append("    background-color: #ffff00; }\n");
        sb.append("  .implied {\n");
        sb.append("    color: #fff;\n");
        sb.append("    font-weight: bold;\n");
        sb.append("    background-color: #000; }\n");
        sb.append("  .pass {\n");
        sb.append("    border-top: 1px solid #488c41;\n");
        sb.append("    border-bottom: 1px solid #488c41;\n");
        sb.append("    padding-bottom: 1px;\n");
        sb.append("    margin-bottom: 2px;\n");
        sb.append("    background-color: #ddffdd; }\n");
        sb.append("  .fail {\n");
        sb.append("    border-top: 1px solid #ab2020;\n");
        sb.append("    border-bottom: 1px solid #ab2020;\n");
        sb.append("    padding-bottom: 1px;\n");
        sb.append("    margin-bottom: 2px;\n");
        sb.append("    background-color: #ffdddd; }\n");
        sb.append("  .skip {\n");
        sb.append("    border-top: 1px solid #ff9900;\n");
        sb.append("    border-bottom: 1px solid #ff9900;\n");
        sb.append("    padding-bottom: 1px;\n");
        sb.append("    margin-bottom: 2px;\n");
        sb.append("    background-color: #ffcc33; }\n");
        sb.append("  .untestable {\n");
        sb.append("    padding-bottom: 16px;\n");
        sb.append("    margin-bottom: 2px;\n");
        sb.append("    border-top: 1px solid #317ba6;\n");
        sb.append("    border-bottom: 1px solid #317ba6;\n");
        sb.append("    background-color: #80d1ff; }\n");
        sb.append("</style>\n");
        sb.append("</head><body>");
        sb.append("<h1>JSR-299 TCK Coverage</h1>");
        sb.append("<h2>");
        sb.append(this.auditParser.getVersion());
        sb.append("</h2>\n");
        out.write(sb.toString().getBytes());
    }

    private void writeContents(OutputStream out) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("<h3>Contents</h3>");
        sb.append("<div><a href=\"#chapterSummary\">Chapter Summary</a></div>");
        sb.append("<div><a href=\"#sectionSummary\">Section Summary</a></div>");
        sb.append("<div><a href=\"#coverageDetail\">Coverage Detail</a></div>");
        sb.append("<div><a href=\"#unmatched\">Unmatched Tests</a></div>");
        out.write(sb.toString().getBytes());
    }

    private void writeChapterSummary(OutputStream out) throws IOException {
        double totalCoveragePercent;
        StringBuilder sb = new StringBuilder();
        sb.append("<h3 id=\"chapterSummary\">Chapter Summary</h3>\n");
        sb.append("<table width=\"100%\">");
        sb.append("<tr style=\"background-color:#dddddd\">");
        sb.append("<th align=\"left\">Chapter</th>");
        sb.append("<th>Assertions</th>");
        sb.append("<th>Testable</th>");
        sb.append("<th>Total Tested</th>");
        sb.append("<th>Tested<br /> (unimplemented)</th>");
        sb.append("<th>Tested<br /> (implemented)</th>");
        sb.append("<th>Coverage %</th>");
        sb.append("</tr>");
        boolean odd = true;
        int totalAssertions = 0;
        int totalTestable = 0;
        int totalTested = 0;
        int totalUnimplemented = 0;
        int totalImplemented = 0;
        for (String sectionId : this.auditParser.getSectionIds()) {
            if (sectionId.split("[.]").length != 1) continue;
            String prefix = sectionId + ".";
            int assertions = this.auditParser.getAssertionsForSection(sectionId).size();
            int testable = 0;
            int implemented = 0;
            int unimplemented = 0;
            for (AuditAssertion assertion : this.auditParser.getAssertionsForSection(sectionId)) {
                TestStatus status;
                if (assertion.isTestable()) {
                    ++testable;
                }
                if ((status = this.getStatus(this.getCoverageForAssertion(sectionId, assertion.getId()))).equals((Object)TestStatus.COVERED)) {
                    ++implemented;
                    continue;
                }
                if (!status.equals((Object)TestStatus.UNIMPLEMENTED)) continue;
                ++unimplemented;
            }
            for (String subSectionId : this.auditParser.getSectionIds()) {
                if (!subSectionId.startsWith(prefix)) continue;
                assertions += this.auditParser.getAssertionsForSection(subSectionId).size();
                for (AuditAssertion assertion : this.auditParser.getAssertionsForSection(subSectionId)) {
                    TestStatus status;
                    if (assertion.isTestable()) {
                        ++testable;
                    }
                    if ((status = this.getStatus(this.getCoverageForAssertion(subSectionId, assertion.getId()))).equals((Object)TestStatus.COVERED)) {
                        ++implemented;
                        continue;
                    }
                    if (!status.equals((Object)TestStatus.UNIMPLEMENTED)) continue;
                    ++unimplemented;
                }
            }
            int tested = implemented + unimplemented;
            double coveragePercent = testable > 0 ? (double)implemented * 1.0 / (double)testable * 100.0 : -1.0;
            totalAssertions += assertions;
            totalTestable += testable;
            totalImplemented += implemented;
            totalTested += tested;
            totalUnimplemented += unimplemented;
            if (odd) {
                sb.append("<tr style=\"background-color:#f7f7f7\">");
            } else {
                sb.append("<tr>");
            }
            odd = !odd;
            int margin = (sectionId.split("[.]").length - 1) * 16;
            sb.append("<td style=\"padding-left:" + margin + "px\">");
            sb.append("<a href=\"#" + sectionId + "\">");
            sb.append(sectionId);
            sb.append(" ");
            sb.append(this.auditParser.getSectionTitle(sectionId));
            sb.append("</a>");
            sb.append("</td>");
            sb.append("<td align=\"center\">");
            sb.append(assertions);
            sb.append("</td>");
            sb.append("<td align=\"center\">");
            sb.append(testable);
            sb.append("</td>");
            sb.append("<td align=\"center\">");
            sb.append(tested);
            sb.append("</td>");
            sb.append("<td align=\"center\">");
            sb.append(unimplemented);
            sb.append("</td>");
            sb.append("<td align=\"center\">");
            sb.append(implemented);
            sb.append("</td>");
            if (coveragePercent >= 0.0) {
                String bgColor = coveragePercent < (double)this.failThreshold ? "#ffaaaa" : (coveragePercent < (double)this.passThreshold ? "#ffffaa" : (coveragePercent > 100.0 ? "#FF00CC" : "#aaffaa"));
                sb.append("<td align=\"center\" style=\"background-color:" + bgColor + "\">");
                sb.append(String.format("%.2f%%", coveragePercent));
                sb.append("</td>");
            } else {
                sb.append("<td />");
            }
            sb.append("</tr>");
        }
        sb.append("<tr style=\"font-weight: bold;background-color:#dddddd\">");
        sb.append("<td>");
        sb.append("Total");
        sb.append("</td>");
        sb.append("<td align=\"center\">");
        sb.append(totalAssertions);
        sb.append("</td>");
        sb.append("<td align=\"center\">");
        sb.append(totalTestable);
        sb.append("</td>");
        sb.append("<td align=\"center\">");
        sb.append(totalTested);
        sb.append("</td>");
        sb.append("<td align=\"center\">");
        sb.append(totalUnimplemented);
        sb.append("</td>");
        sb.append("<td align=\"center\">");
        sb.append(totalImplemented);
        sb.append("</td>");
        double d = totalCoveragePercent = totalTestable > 0 ? (double)totalImplemented * 1.0 / (double)totalTestable * 100.0 : -1.0;
        if (totalCoveragePercent >= 0.0) {
            String bgColor = totalCoveragePercent < (double)this.failThreshold ? "#ffaaaa" : (totalCoveragePercent < (double)this.passThreshold ? "#ffffaa" : "#aaffaa");
            sb.append("<td align=\"center\" style=\"background-color:" + bgColor + "\">");
            sb.append(String.format("%.2f%%", totalCoveragePercent));
            sb.append("</td>");
        } else {
            sb.append("<td />");
        }
        sb.append("</tr>");
        sb.append("</table>");
        out.write(sb.toString().getBytes());
    }

    private void writeSectionSummary(OutputStream out) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("<h3 id=\"sectionSummary\">Section Summary</h3>\n");
        sb.append("<table width=\"100%\">");
        sb.append("<tr style=\"background-color:#dddddd\">");
        sb.append("<th align=\"left\">Section</th>");
        sb.append("<th>Assertions</th>");
        sb.append("<th>Testable</th>");
        sb.append("<th>Total Tested</th>");
        sb.append("<th>Tested<br /> (unimplemented)</th>");
        sb.append("<th>Tested<br /> (implemented)</th>");
        sb.append("<th>Coverage %</th>");
        sb.append("</tr>");
        boolean odd = true;
        for (String sectionId : this.auditParser.getSectionIds()) {
            if (odd) {
                sb.append("<tr style=\"background-color:#f7f7f7\">");
            } else {
                sb.append("<tr>");
            }
            odd = !odd;
            int margin = (sectionId.split("[.]").length - 1) * 16;
            sb.append("<td style=\"padding-left:" + margin + "px\">");
            sb.append("<a href=\"#" + sectionId + "\">");
            sb.append(sectionId);
            sb.append(" ");
            sb.append(this.auditParser.getSectionTitle(sectionId));
            sb.append("</a>");
            sb.append("</td>");
            int assertions = this.auditParser.getAssertionsForSection(sectionId).size();
            int testable = 0;
            int implemented = 0;
            int unimplemented = 0;
            for (AuditAssertion assertion : this.auditParser.getAssertionsForSection(sectionId)) {
                TestStatus status;
                if (assertion.isTestable()) {
                    ++testable;
                }
                if ((status = this.getStatus(this.getCoverageForAssertion(sectionId, assertion.getId()))).equals((Object)TestStatus.COVERED)) {
                    ++implemented;
                    continue;
                }
                if (!status.equals((Object)TestStatus.UNIMPLEMENTED)) continue;
                ++unimplemented;
            }
            int tested = implemented + unimplemented;
            double coveragePercent = testable > 0 ? (double)implemented * 1.0 / (double)testable * 100.0 : -1.0;
            sb.append("<td align=\"center\">");
            sb.append(assertions);
            sb.append("</td>");
            sb.append("<td align=\"center\">");
            sb.append(testable);
            sb.append("</td>");
            sb.append("<td align=\"center\">");
            sb.append(tested);
            sb.append("</td>");
            sb.append("<td align=\"center\">");
            sb.append(unimplemented);
            sb.append("</td>");
            sb.append("<td align=\"center\">");
            sb.append(implemented);
            sb.append("</td>");
            if (coveragePercent >= 0.0) {
                String bgColor = coveragePercent < (double)this.failThreshold ? "#ffaaaa" : (coveragePercent < (double)this.passThreshold ? "#ffffaa" : (coveragePercent > 100.0 ? "#FF00CC" : "#aaffaa"));
                sb.append("<td align=\"center\" style=\"background-color:" + bgColor + "\">");
                sb.append(String.format("%.2f%%", coveragePercent));
                sb.append("</td>");
            } else {
                sb.append("<td />");
            }
            sb.append("</tr>");
        }
        sb.append("</table>");
        out.write(sb.toString().getBytes());
    }

    private void writeCoverage(OutputStream out) throws IOException {
        out.write("<h3 id=\"coverageDetail\">Coverage Detail</h3>\n".getBytes());
        StringBuilder key = new StringBuilder();
        key.append("<table>");
        key.append("<tr><th style=\"background-color:#dddddd\">Colour Key</th></tr>");
        key.append("<tr><td style=\"background-color:#ddffdd;text-align:center\">Assertion is covered</td></tr>");
        key.append("<tr><td style=\"background-color:#ffdddd;text-align:center\">Assertion is not covered</td></tr>");
        key.append("<tr><td style=\"background-color:#ffcc33;text-align:center\">Assertion test is unimplemented</td></tr>");
        key.append("<tr><td style=\"background-color:#80d1ff;text-align:center\">Assertion is untestable</td></tr>");
        key.append("</table>");
        out.write(key.toString().getBytes());
        for (String sectionId : this.auditParser.getSectionIds()) {
            List<AuditAssertion> sectionAssertions = this.auditParser.getAssertionsForSection(sectionId);
            if (sectionAssertions == null || sectionAssertions.isEmpty()) continue;
            StringBuilder sb = new StringBuilder();
            out.write(("<h4 class=\"sectionHeader\" id=\"" + sectionId + "\">Section " + sectionId + " - " + this.auditParser.getSectionTitle(sectionId) + "</h4>\n").getBytes());
            for (AuditAssertion assertion : sectionAssertions) {
                List<SpecReference> coverage = this.getCoverageForAssertion(sectionId, assertion.getId());
                TestStatus status = this.getStatus(coverage);
                String divClass = null;
                divClass = assertion.isTestable() ? (status.equals((Object)TestStatus.UNCOVERED) ? "fail" : (status.equals((Object)TestStatus.UNIMPLEMENTED) ? "skip" : "pass")) : "untestable";
                sb.append("  <div class=\"" + divClass + "\">\n");
                if (assertion.isImplied()) {
                    sb.append("<span class=\"implied\">The following assertion is not made explicitly by the spec, however it is implied</span>");
                }
                sb.append("    <span class=\"code\">");
                sb.append(assertion.getId());
                sb.append(")");
                sb.append("</span>\n");
                sb.append("    <div class=\"results\">");
                sb.append("<p class=\"description\">");
                String imageFilename = sectionId + "." + assertion.getId() + ".png";
                File imageFile = new File(this.imageSrcDir, imageFilename);
                if (imageFile.exists()) {
                    sb.append("<img src=\"images/" + imageFile.getName() + "\" class=\"embeddedImage\"/>");
                    this.copyFile(imageFile, new File(this.imageTargetDir, imageFilename));
                }
                String assertionText = this.parseStrikethrough(this.parseBold(assertion.getText()));
                if (!Strings.isEmpty(assertion.getNote())) {
                    sb.append("<a title=\"" + assertion.getNote() + "\">");
                    sb.append(assertionText);
                    sb.append("</a>");
                } else {
                    sb.append(assertionText);
                }
                sb.append("</p>\n");
                if (assertion.isTestable()) {
                    sb.append("    <div class=\"coverage\">\n");
                    sb.append("      <p class=\"coverageHeader\">Coverage</p>\n");
                    String currentPackageName = null;
                    if (status.equals((Object)TestStatus.UNCOVERED)) {
                        sb.append("        <p class=\"noCoverage\">No tests exist for this assertion</p>\n");
                    } else {
                        for (SpecReference ref : coverage) {
                            if (!ref.getPackageName().equals(currentPackageName)) {
                                currentPackageName = ref.getPackageName();
                                sb.append("        <div class=\"packageName\">");
                                sb.append(currentPackageName);
                                sb.append("        </div>\n");
                            }
                            sb.append("        <div class=\"coverageMethod\">");
                            sb.append(ref.getClassName());
                            sb.append(".");
                            sb.append(ref.getMethodName());
                            sb.append("()");
                            if (this.fisheyeBaseUrl != null) {
                                sb.append("<a class=\"external\" target=\"_blank\" href=\"");
                                sb.append(this.fisheyeBaseUrl);
                                sb.append(currentPackageName.replace('.', '/'));
                                sb.append("/");
                                sb.append(ref.getClassName());
                                sb.append(".java");
                                sb.append("\">fisheye</a>");
                            }
                            if (this.svnBaseUrl != null) {
                                if (this.fisheyeBaseUrl != null) {
                                    sb.append("|");
                                }
                                sb.append("<a class=\"external\" target=\"_blank\" href=\"");
                                sb.append(this.svnBaseUrl);
                                sb.append(currentPackageName.replace('.', '/'));
                                sb.append("/");
                                sb.append(ref.getClassName());
                                sb.append(".java");
                                sb.append("\">svn</a>");
                            }
                            sb.append("</div>\n");
                        }
                    }
                    sb.append("    </div>\n");
                } else if (!coverage.isEmpty()) {
                    sb.append("<b>A test exists for this untestable assertion!</b>");
                }
                sb.append("</div></div>");
            }
            out.write(sb.toString().getBytes());
        }
    }

    private String parseBold(String text) {
        Matcher m = PATTERN_BOLD.matcher(text);
        String result = text;
        while (m.find()) {
            String replacement = "<span class=\"highlight\">" + m.group().substring(1, m.group().length() - 1) + "</span>";
            result = m.replaceFirst(replacement);
            m.reset(result);
        }
        return result;
    }

    private String parseStrikethrough(String text) {
        Matcher m = PATTERN_STRIKETHROUGH.matcher(text);
        String result = text;
        while (m.find()) {
            String replacement = "<del>" + m.group().substring(1, m.group().length() - 1) + "</del>";
            result = m.replaceFirst(replacement);
            m.reset(result);
        }
        return result;
    }

    private void writeUnmatched(OutputStream out) throws IOException {
        if (this.unmatched.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<h3 id=\"unmatched\">Unmatched tests</h3>\n");
        sb.append(String.format("<p>The following %d tests do not match any known assertions:</p>", this.unmatched.size()));
        sb.append("<table border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n");
        sb.append("  <tr><th>Section</th><th>Assertion</th><th>Test Class</th><th>Test Method</th></tr>\n");
        for (SpecReference ref : this.unmatched) {
            sb.append("<tr>");
            sb.append("<td>");
            sb.append(ref.getSection());
            sb.append("</td>");
            sb.append("<td>");
            sb.append(ref.getAssertion());
            sb.append("</td>");
            sb.append("<td>");
            sb.append("<div class=\"packageName\">");
            sb.append(ref.getPackageName());
            sb.append("</div>");
            sb.append(ref.getClassName());
            sb.append("</td>");
            sb.append("<td>");
            sb.append(ref.getMethodName());
            sb.append("()");
            sb.append("</td>");
            sb.append("</tr>");
        }
        sb.append("</table>");
        out.write(sb.toString().getBytes());
    }

    private List<SpecReference> getCoverageForAssertion(String sectionId, String assertionId) {
        ArrayList<SpecReference> refs = new ArrayList<SpecReference>();
        if (this.references.containsKey(sectionId)) {
            for (SpecReference ref : this.references.get(sectionId)) {
                if (!ref.getAssertion().equals(assertionId)) continue;
                refs.add(ref);
            }
        }
        return refs;
    }

    private TestStatus getStatus(List<SpecReference> references) {
        if (references.isEmpty()) {
            return TestStatus.UNCOVERED;
        }
        for (SpecReference reference : references) {
            if (!this.isImplemented(reference.getGroups())) continue;
            return TestStatus.COVERED;
        }
        return TestStatus.UNIMPLEMENTED;
    }

    private boolean isImplemented(List<String> groups) {
        for (String group : groups) {
            if (!this.unimplementedTestGroups.contains(group)) continue;
            return false;
        }
        return true;
    }

    private void writeFooter(OutputStream out) throws IOException {
        out.write("</table>".getBytes());
        out.write("</body></html>".getBytes());
    }

    private void copyFile(File sourceFile, File targetFile) throws IOException {
        FileChannel inChannel = new FileInputStream(sourceFile).getChannel();
        FileChannel outChannel = new FileOutputStream(targetFile).getChannel();
        try {
            inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }

    public static enum TestStatus {
        COVERED,
        UNCOVERED,
        UNIMPLEMENTED;

    }
}

