/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.cli.commands;

import io.airlift.command.Arguments;
import io.airlift.command.Command;
import java.io.File;
import org.hornetq.cli.commands.Action;
import org.hornetq.cli.commands.ActionContext;
import org.hornetq.dto.BrokerDTO;
import org.hornetq.factory.BrokerFactory;

@Command(name="stop", description="stops the broker instance")
public class Stop
implements Action {
    @Arguments(description="Broker Configuration URI, default 'xml:${HORNETQ_HOME}/config/non-clustered/bootstrap.xml'")
    String configuration;

    @Override
    public Object execute(ActionContext context) throws Exception {
        if (this.configuration == null) {
            this.configuration = "xml:" + System.getProperty("hornetq.home").replace("\\", "/") + "/config/non-clustered/bootstrap.xml";
        }
        BrokerDTO broker = BrokerFactory.createBroker(this.configuration);
        File file = new File(broker.core.configuration).getParentFile();
        File stopFile = new File(file, "STOP_ME");
        stopFile.createNewFile();
        return null;
    }
}

