/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.factory;

import java.io.IOException;
import java.net.URI;
import org.hornetq.cli.ConfigurationException;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.hornetq.dto.CoreDTO;
import org.hornetq.factory.CoreFactoryHandler;
import org.hornetq.utils.FactoryFinder;

public class CoreFactory {
    public static Configuration create(CoreDTO core) throws Exception {
        if (core.configuration != null) {
            CoreFactoryHandler factory = null;
            URI configURI = new URI(core.configuration.replace("\\", "/"));
            try {
                FactoryFinder finder = new FactoryFinder("META-INF/services/org/hornetq/broker/core/");
                factory = (CoreFactoryHandler)finder.newInstance(configURI.getScheme());
            }
            catch (IOException ioe) {
                throw new ConfigurationException("Invalid configuration URI, can't find configuration scheme: " + configURI.getScheme());
            }
            return factory.createConfiguration(configURI);
        }
        return new ConfigurationImpl();
    }
}

