/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.factory;

import java.io.IOException;
import java.net.URI;
import org.hornetq.cli.ConfigurationException;
import org.hornetq.dto.JmsDTO;
import org.hornetq.factory.JmsFactoryHandler;
import org.hornetq.jms.server.config.JMSConfiguration;
import org.hornetq.utils.FactoryFinder;

public class JmsFactory {
    public static JMSConfiguration create(JmsDTO jms) throws Exception {
        if (jms != null && jms.configuration != null) {
            JmsFactoryHandler factory = null;
            URI configURI = new URI(jms.configuration.replace("\\", "/"));
            try {
                FactoryFinder finder = new FactoryFinder("META-INF/services/org/hornetq/broker/jms/");
                factory = (JmsFactoryHandler)finder.newInstance(configURI.getScheme());
            }
            catch (IOException ioe) {
                throw new ConfigurationException("Invalid configuration URI, can't find configuration scheme: " + configURI.getScheme());
            }
            return factory.createConfiguration(configURI);
        }
        return null;
    }
}

