/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.checks.annotation;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredAnnotationCheck
extends Check {
    private String annotationName;
    private Set<String> requiredParameters = new HashSet<String>();

    public void setAnnotationName(String annotationName) {
        this.annotationName = annotationName;
    }

    public void setRequiredParameters(String[] requiredPropertiesParameter) {
        if (requiredPropertiesParameter != null) {
            for (String item : requiredPropertiesParameter) {
                this.requiredParameters.add(item);
            }
        }
    }

    protected String getAnnotationName(DetailAST aAnnotation) {
        DetailAST directname = aAnnotation.findFirstToken(58);
        if (directname != null) {
            return directname.getText();
        }
        return aAnnotation.findFirstToken(59).getLastChild().getText();
    }

    protected String[] getAnnotationParameters(DetailAST aAnnotation) {
        LinkedList<DetailAST> parameters = new LinkedList<DetailAST>();
        Object retVal = null;
        for (DetailAST i = aAnnotation.getFirstChild(); i != null; i = i.getNextSibling()) {
            if (i.getType() != 160) continue;
            parameters.add(i);
        }
        String[] names = new String[parameters.size()];
        int count = 0;
        for (DetailAST itemIter : parameters) {
            names[count++] = itemIter.getFirstChild().getText();
        }
        return names;
    }

    public int[] getDefaultTokens() {
        return new int[]{159};
    }

    public void visitToken(DetailAST aAST) {
        String annotationName = this.getAnnotationName(aAST);
        if (annotationName.equals(this.annotationName)) {
            String[] names;
            HashSet<String> missingParameters = new HashSet<String>(this.requiredParameters);
            for (String lookupParameter : names = this.getAnnotationParameters(aAST)) {
                missingParameters.remove(lookupParameter);
            }
            if (missingParameters.size() != 0) {
                String propertiesText = this.mergeText(missingParameters.iterator());
                this.log(aAST, "Annotation @{0} is missing required parameters: ({1})", new Object[]{this.annotationName, propertiesText.toString()});
            }
        }
    }

    private String mergeText(Iterator<String> properties) {
        StringBuilder propertiesText = new StringBuilder();
        while (properties.hasNext()) {
            String text = properties.next();
            propertiesText.append(text);
            if (!properties.hasNext()) continue;
            propertiesText.append(",");
        }
        return propertiesText.toString();
    }
}

