/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.integration.jboss.recovery;

import org.hornetq.jms.server.recovery.HornetQResourceRecovery;
import org.hornetq.jms.server.recovery.RecoveryRegistry;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.tm.XAResourceRecovery;
import org.jboss.tm.XAResourceRecoveryRegistry;

public class AS7RecoveryRegistry
implements RecoveryRegistry {
    public static final ServiceName RECOVERY_MANAGER = ServiceName.JBOSS.append(new String[]{"txn"}).append(new String[]{"ArjunaRecoveryManager"});
    public static volatile ServiceContainer container;
    private XAResourceRecoveryRegistry registry = AS7RecoveryRegistry.getXAResourceRecoveryRegistry();

    public AS7RecoveryRegistry() {
        if (this.registry == null) {
            throw new IllegalStateException("Unable to find Recovery Registry");
        }
    }

    @Override
    public void register(HornetQResourceRecovery resourceRecovery) {
        this.registry.addXAResourceRecovery((XAResourceRecovery)resourceRecovery);
    }

    @Override
    public void unRegister(HornetQResourceRecovery resourceRecovery) {
        this.registry.removeXAResourceRecovery((XAResourceRecovery)resourceRecovery);
    }

    private static XAResourceRecoveryRegistry getXAResourceRecoveryRegistry() {
        ServiceController service = container.getService(RECOVERY_MANAGER);
        return service == null ? null : (XAResourceRecoveryRegistry)service.getValue();
    }
}

