/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import java.io.Serializable;
import java.util.List;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.hornetq.core.client.ClientSessionFactory;
import org.hornetq.core.client.impl.ClientSessionFactoryImpl;
import org.hornetq.core.config.TransportConfiguration;
import org.hornetq.core.logging.Logger;
import org.hornetq.jms.client.HornetQConnection;
import org.hornetq.jms.referenceable.ConnectionFactoryObjectFactory;
import org.hornetq.jms.referenceable.SerializableObjectRefAddr;
import org.hornetq.utils.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HornetQConnectionFactory
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory,
XAConnectionFactory,
XAQueueConnectionFactory,
XATopicConnectionFactory,
Serializable {
    private static final long serialVersionUID = -2810634789345348326L;
    private static final Logger log = Logger.getLogger(HornetQConnectionFactory.class);
    private ClientSessionFactory sessionFactory;
    private String clientID;
    private int dupsOKBatchSize = 0x100000;
    private int transactionBatchSize = 0x100000;
    private boolean readOnly;

    public HornetQConnectionFactory() {
        this.sessionFactory = new ClientSessionFactoryImpl();
    }

    public HornetQConnectionFactory(ClientSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public HornetQConnectionFactory(String discoveryAddress, int discoveryPort) {
        this.sessionFactory = new ClientSessionFactoryImpl(discoveryAddress, discoveryPort);
    }

    public HornetQConnectionFactory(List<Pair<TransportConfiguration, TransportConfiguration>> staticConnectors) {
        this.sessionFactory = new ClientSessionFactoryImpl(staticConnectors);
    }

    public HornetQConnectionFactory(TransportConfiguration connectorConfig, TransportConfiguration backupConnectorConfig) {
        this.sessionFactory = new ClientSessionFactoryImpl(connectorConfig, backupConnectorConfig);
    }

    public HornetQConnectionFactory(TransportConfiguration connectorConfig) {
        this(connectorConfig, null);
    }

    public Connection createConnection() throws JMSException {
        return this.createConnection(null, null);
    }

    public Connection createConnection(String username, String password) throws JMSException {
        return this.createConnectionInternal(username, password, false, 0);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return this.createQueueConnection(null, null);
    }

    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        return this.createConnectionInternal(username, password, false, 1);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return this.createTopicConnection(null, null);
    }

    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        return this.createConnectionInternal(username, password, false, 2);
    }

    public XAConnection createXAConnection() throws JMSException {
        return this.createXAConnection(null, null);
    }

    public XAConnection createXAConnection(String username, String password) throws JMSException {
        return this.createConnectionInternal(username, password, true, 0);
    }

    public XAQueueConnection createXAQueueConnection() throws JMSException {
        return this.createXAQueueConnection(null, null);
    }

    public XAQueueConnection createXAQueueConnection(String username, String password) throws JMSException {
        return this.createConnectionInternal(username, password, true, 1);
    }

    public XATopicConnection createXATopicConnection() throws JMSException {
        return this.createXATopicConnection(null, null);
    }

    public XATopicConnection createXATopicConnection(String username, String password) throws JMSException {
        return this.createConnectionInternal(username, password, true, 2);
    }

    public Reference getReference() throws NamingException {
        return new Reference(this.getClass().getCanonicalName(), new SerializableObjectRefAddr("HornetQ-CF", this), ConnectionFactoryObjectFactory.class.getCanonicalName(), null);
    }

    public synchronized String getConnectionLoadBalancingPolicyClassName() {
        return this.sessionFactory.getConnectionLoadBalancingPolicyClassName();
    }

    public synchronized void setConnectionLoadBalancingPolicyClassName(String connectionLoadBalancingPolicyClassName) {
        this.sessionFactory.setConnectionLoadBalancingPolicyClassName(connectionLoadBalancingPolicyClassName);
    }

    public synchronized List<Pair<TransportConfiguration, TransportConfiguration>> getStaticConnectors() {
        return this.sessionFactory.getStaticConnectors();
    }

    public synchronized void setStaticConnectors(List<Pair<TransportConfiguration, TransportConfiguration>> staticConnectors) {
        this.sessionFactory.setStaticConnectors(staticConnectors);
    }

    public synchronized String getDiscoveryAddress() {
        return this.sessionFactory.getDiscoveryAddress();
    }

    public synchronized void setDiscoveryAddress(String discoveryAddress) {
        this.sessionFactory.setDiscoveryAddress(discoveryAddress);
    }

    public synchronized int getDiscoveryPort() {
        return this.sessionFactory.getDiscoveryPort();
    }

    public synchronized void setDiscoveryPort(int discoveryPort) {
        this.sessionFactory.setDiscoveryPort(discoveryPort);
    }

    public synchronized long getDiscoveryRefreshTimeout() {
        return this.sessionFactory.getDiscoveryRefreshTimeout();
    }

    public synchronized void setDiscoveryRefreshTimeout(long discoveryRefreshTimeout) {
        this.sessionFactory.setDiscoveryRefreshTimeout(discoveryRefreshTimeout);
    }

    public synchronized long getDiscoveryInitialWaitTimeout() {
        return this.sessionFactory.getDiscoveryInitialWaitTimeout();
    }

    public synchronized void setDiscoveryInitialWaitTimeout(long discoveryInitialWaitTimeout) {
        this.sessionFactory.setDiscoveryInitialWaitTimeout(discoveryInitialWaitTimeout);
    }

    public synchronized String getClientID() {
        return this.clientID;
    }

    public synchronized void setClientID(String clientID) {
        this.checkWrite();
        this.clientID = clientID;
    }

    public synchronized int getDupsOKBatchSize() {
        return this.dupsOKBatchSize;
    }

    public synchronized void setDupsOKBatchSize(int dupsOKBatchSize) {
        this.checkWrite();
        this.dupsOKBatchSize = dupsOKBatchSize;
    }

    public synchronized int getTransactionBatchSize() {
        return this.transactionBatchSize;
    }

    public synchronized void setTransactionBatchSize(int transactionBatchSize) {
        this.checkWrite();
        this.transactionBatchSize = transactionBatchSize;
    }

    public synchronized long getClientFailureCheckPeriod() {
        return this.sessionFactory.getClientFailureCheckPeriod();
    }

    public synchronized void setClientFailureCheckPeriod(long clientFailureCheckPeriod) {
        this.sessionFactory.setClientFailureCheckPeriod(clientFailureCheckPeriod);
    }

    public synchronized long getConnectionTTL() {
        return this.sessionFactory.getConnectionTTL();
    }

    public synchronized void setConnectionTTL(long connectionTTL) {
        this.sessionFactory.setConnectionTTL(connectionTTL);
    }

    public synchronized long getCallTimeout() {
        return this.sessionFactory.getCallTimeout();
    }

    public synchronized void setCallTimeout(long callTimeout) {
        this.sessionFactory.setCallTimeout(callTimeout);
    }

    public synchronized int getConsumerWindowSize() {
        return this.sessionFactory.getConsumerWindowSize();
    }

    public synchronized void setConsumerWindowSize(int consumerWindowSize) {
        this.sessionFactory.setConsumerWindowSize(consumerWindowSize);
    }

    public synchronized int getConsumerMaxRate() {
        return this.sessionFactory.getConsumerMaxRate();
    }

    public synchronized void setConsumerMaxRate(int consumerMaxRate) {
        this.sessionFactory.setConsumerMaxRate(consumerMaxRate);
    }

    public synchronized int getProducerWindowSize() {
        return this.sessionFactory.getProducerWindowSize();
    }

    public synchronized void setProducerWindowSize(int producerWindowSize) {
        this.sessionFactory.setProducerWindowSize(producerWindowSize);
    }

    public synchronized int getProducerMaxRate() {
        return this.sessionFactory.getProducerMaxRate();
    }

    public synchronized void setProducerMaxRate(int producerMaxRate) {
        this.sessionFactory.setProducerMaxRate(producerMaxRate);
    }

    public synchronized void setCacheLargeMessagesClient(boolean cacheLargeMessagesClient) {
        this.sessionFactory.setCacheLargeMessagesClient(cacheLargeMessagesClient);
    }

    public synchronized boolean isCacheLargeMessagesClient() {
        return this.sessionFactory.isCacheLargeMessagesClient();
    }

    public synchronized int getMinLargeMessageSize() {
        return this.sessionFactory.getMinLargeMessageSize();
    }

    public synchronized void setMinLargeMessageSize(int minLargeMessageSize) {
        this.sessionFactory.setMinLargeMessageSize(minLargeMessageSize);
    }

    public synchronized boolean isBlockOnAcknowledge() {
        return this.sessionFactory.isBlockOnAcknowledge();
    }

    public synchronized void setBlockOnAcknowledge(boolean blockOnAcknowledge) {
        this.sessionFactory.setBlockOnAcknowledge(blockOnAcknowledge);
    }

    public synchronized boolean isBlockOnNonPersistentSend() {
        return this.sessionFactory.isBlockOnNonPersistentSend();
    }

    public synchronized void setBlockOnNonPersistentSend(boolean blockOnNonPersistentSend) {
        this.sessionFactory.setBlockOnNonPersistentSend(blockOnNonPersistentSend);
    }

    public synchronized boolean isBlockOnPersistentSend() {
        return this.sessionFactory.isBlockOnPersistentSend();
    }

    public synchronized void setBlockOnPersistentSend(boolean blockOnPersistentSend) {
        this.sessionFactory.setBlockOnPersistentSend(blockOnPersistentSend);
    }

    public synchronized boolean isAutoGroup() {
        return this.sessionFactory.isAutoGroup();
    }

    public synchronized void setAutoGroup(boolean autoGroup) {
        this.sessionFactory.setAutoGroup(autoGroup);
    }

    public synchronized int getMaxConnections() {
        return this.sessionFactory.getMaxConnections();
    }

    public synchronized void setMaxConnections(int maxConnections) {
        this.sessionFactory.setMaxConnections(maxConnections);
    }

    public synchronized boolean isPreAcknowledge() {
        return this.sessionFactory.isPreAcknowledge();
    }

    public synchronized void setPreAcknowledge(boolean preAcknowledge) {
        this.sessionFactory.setPreAcknowledge(preAcknowledge);
    }

    public synchronized long getRetryInterval() {
        return this.sessionFactory.getRetryInterval();
    }

    public synchronized void setRetryInterval(long retryInterval) {
        this.sessionFactory.setRetryInterval(retryInterval);
    }

    public synchronized double getRetryIntervalMultiplier() {
        return this.sessionFactory.getRetryIntervalMultiplier();
    }

    public synchronized void setRetryIntervalMultiplier(double retryIntervalMultiplier) {
        this.sessionFactory.setRetryIntervalMultiplier(retryIntervalMultiplier);
    }

    public synchronized int getReconnectAttempts() {
        return this.sessionFactory.getReconnectAttempts();
    }

    public synchronized void setReconnectAttempts(int reconnectAttempts) {
        this.sessionFactory.setReconnectAttempts(reconnectAttempts);
    }

    public synchronized boolean isFailoverOnServerShutdown() {
        return this.sessionFactory.isFailoverOnServerShutdown();
    }

    public synchronized void setFailoverOnServerShutdown(boolean failoverOnServerShutdown) {
        this.sessionFactory.setFailoverOnServerShutdown(failoverOnServerShutdown);
    }

    public synchronized boolean isUseGlobalPools() {
        return this.sessionFactory.isUseGlobalPools();
    }

    public synchronized void setUseGlobalPools(boolean useGlobalPools) {
        this.sessionFactory.setUseGlobalPools(useGlobalPools);
    }

    public synchronized int getScheduledThreadPoolMaxSize() {
        return this.sessionFactory.getScheduledThreadPoolMaxSize();
    }

    public synchronized void setScheduledThreadPoolMaxSize(int scheduledThreadPoolMaxSize) {
        this.sessionFactory.setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
    }

    public synchronized int getThreadPoolMaxSize() {
        return this.sessionFactory.getThreadPoolMaxSize();
    }

    public synchronized void setThreadPoolMaxSize(int threadPoolMaxSize) {
        this.sessionFactory.setThreadPoolMaxSize(threadPoolMaxSize);
    }

    public ClientSessionFactory getCoreFactory() {
        return this.sessionFactory;
    }

    public void close() {
        this.sessionFactory.close();
    }

    protected synchronized HornetQConnection createConnectionInternal(String username, String password, boolean isXA, int type) throws JMSException {
        this.readOnly = true;
        HornetQConnection connection = new HornetQConnection(username, password, type, this.clientID, this.dupsOKBatchSize, this.transactionBatchSize, this.sessionFactory);
        try {
            connection.authorize();
        }
        catch (JMSException e) {
            try {
                connection.close();
            }
            catch (JMSException me) {
                // empty catch block
            }
            throw e;
        }
        return connection;
    }

    private void checkWrite() {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot set attribute on HornetQRAConnectionFactory after it has been used");
        }
    }
}

