/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import org.hornetq.core.client.ClientMessage;
import org.hornetq.core.client.ClientSession;
import org.hornetq.jms.client.HornetQMessage;
import org.hornetq.utils.SimpleString;
import org.hornetq.utils.TypedProperties;

public class HornetQMapMessage
extends HornetQMessage
implements MapMessage {
    public static final byte TYPE = 5;
    private TypedProperties map = new TypedProperties();

    public HornetQMapMessage() {
        super((byte)5);
        this.map = new TypedProperties();
    }

    public HornetQMapMessage(ClientSession session) {
        super((byte)5, session);
        this.map = new TypedProperties();
    }

    public HornetQMapMessage(ClientMessage message, ClientSession session) {
        super(message, session);
    }

    public HornetQMapMessage(MapMessage foreign, ClientSession session) throws JMSException {
        super((Message)foreign, (byte)5, session);
        Enumeration names = foreign.getMapNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object obj = foreign.getObject(name);
            this.setObject(name, obj);
        }
    }

    public byte getType() {
        return 5;
    }

    public void setBoolean(String name, boolean value) throws JMSException {
        this.checkName(name);
        this.map.putBooleanProperty(new SimpleString(name), value);
    }

    public void setByte(String name, byte value) throws JMSException {
        this.checkName(name);
        this.map.putByteProperty(new SimpleString(name), value);
    }

    public void setShort(String name, short value) throws JMSException {
        this.checkName(name);
        this.map.putShortProperty(new SimpleString(name), value);
    }

    public void setChar(String name, char value) throws JMSException {
        this.checkName(name);
        this.map.putCharProperty(new SimpleString(name), value);
    }

    public void setInt(String name, int value) throws JMSException {
        this.checkName(name);
        this.map.putIntProperty(new SimpleString(name), value);
    }

    public void setLong(String name, long value) throws JMSException {
        this.checkName(name);
        this.map.putLongProperty(new SimpleString(name), value);
    }

    public void setFloat(String name, float value) throws JMSException {
        this.checkName(name);
        this.map.putFloatProperty(new SimpleString(name), value);
    }

    public void setDouble(String name, double value) throws JMSException {
        this.checkName(name);
        this.map.putDoubleProperty(new SimpleString(name), value);
    }

    public void setString(String name, String value) throws JMSException {
        this.checkName(name);
        this.map.putStringProperty(new SimpleString(name), value == null ? null : new SimpleString(value));
    }

    public void setBytes(String name, byte[] value) throws JMSException {
        this.checkName(name);
        this.map.putBytesProperty(new SimpleString(name), value);
    }

    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        this.checkName(name);
        if (offset + length > value.length) {
            throw new JMSException("Invalid offset/length");
        }
        byte[] newBytes = new byte[length];
        System.arraycopy(value, offset, newBytes, 0, length);
        this.map.putBytesProperty(new SimpleString(name), newBytes);
    }

    public void setObject(String name, Object value) throws JMSException {
        this.checkName(name);
        SimpleString key = new SimpleString(name);
        if (value instanceof Boolean) {
            this.map.putBooleanProperty(key, ((Boolean)value).booleanValue());
        } else if (value instanceof Byte) {
            this.map.putByteProperty(key, ((Byte)value).byteValue());
        } else if (value instanceof Short) {
            this.map.putShortProperty(key, ((Short)value).shortValue());
        } else if (value instanceof Character) {
            this.map.putCharProperty(key, ((Character)value).charValue());
        } else if (value instanceof Integer) {
            this.map.putIntProperty(key, ((Integer)value).intValue());
        } else if (value instanceof Long) {
            this.map.putLongProperty(key, ((Long)value).longValue());
        } else if (value instanceof Float) {
            this.map.putFloatProperty(key, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.map.putDoubleProperty(key, ((Double)value).doubleValue());
        } else if (value instanceof String) {
            this.map.putStringProperty(key, new SimpleString((String)value));
        } else if (value instanceof byte[]) {
            this.map.putBytesProperty(key, (byte[])value);
        } else {
            throw new MessageFormatException("Invalid object type.");
        }
    }

    public boolean getBoolean(String name) throws JMSException {
        Object value = this.map.getProperty(new SimpleString(name));
        if (value == null) {
            return Boolean.valueOf(null);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof SimpleString) {
            return Boolean.valueOf(((SimpleString)value).toString());
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public byte getByte(String name) throws JMSException {
        Object value = this.map.getProperty(new SimpleString(name));
        if (value == null) {
            return Byte.parseByte(null);
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof SimpleString) {
            return Byte.parseByte(((SimpleString)value).toString());
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public short getShort(String name) throws JMSException {
        Object value = this.map.getProperty(new SimpleString(name));
        if (value == null) {
            return Short.parseShort(null);
        }
        if (value instanceof Byte) {
            return ((Byte)value).shortValue();
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof SimpleString) {
            return Short.parseShort(((SimpleString)value).toString());
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public char getChar(String name) throws JMSException {
        Object value = this.map.getProperty(new SimpleString(name));
        if (value == null) {
            throw new NullPointerException("Invalid conversion");
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public int getInt(String name) throws JMSException {
        Object value = this.map.getProperty(new SimpleString(name));
        if (value == null) {
            return Integer.parseInt(null);
        }
        if (value instanceof Byte) {
            return ((Byte)value).intValue();
        }
        if (value instanceof Short) {
            return ((Short)value).intValue();
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof SimpleString) {
            return Integer.parseInt(((SimpleString)value).toString());
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public long getLong(String name) throws JMSException {
        Object value = this.map.getProperty(new SimpleString(name));
        if (value == null) {
            return Long.parseLong(null);
        }
        if (value instanceof Byte) {
            return ((Byte)value).longValue();
        }
        if (value instanceof Short) {
            return ((Short)value).longValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof SimpleString) {
            return Long.parseLong(((SimpleString)value).toString());
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public float getFloat(String name) throws JMSException {
        Object value = this.map.getProperty(new SimpleString(name));
        if (value == null) {
            return Float.parseFloat(null);
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof SimpleString) {
            return Float.parseFloat(((SimpleString)value).toString());
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public double getDouble(String name) throws JMSException {
        Object value = this.map.getProperty(new SimpleString(name));
        if (value == null) {
            return Double.parseDouble(null);
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof SimpleString) {
            return Double.parseDouble(((SimpleString)value).toString());
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public String getString(String name) throws JMSException {
        Object value = this.map.getProperty(new SimpleString(name));
        if (value == null) {
            return null;
        }
        if (value instanceof SimpleString) {
            return ((SimpleString)value).toString();
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof Byte) {
            return value.toString();
        }
        if (value instanceof Short) {
            return value.toString();
        }
        if (value instanceof Character) {
            return value.toString();
        }
        if (value instanceof Integer) {
            return value.toString();
        }
        if (value instanceof Long) {
            return value.toString();
        }
        if (value instanceof Float) {
            return value.toString();
        }
        if (value instanceof Double) {
            return value.toString();
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public byte[] getBytes(String name) throws JMSException {
        Object value = this.map.getProperty(new SimpleString(name));
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public Object getObject(String name) throws JMSException {
        Object val = this.map.getProperty(new SimpleString(name));
        if (val instanceof SimpleString) {
            val = ((SimpleString)val).toString();
        }
        return val;
    }

    public Enumeration getMapNames() throws JMSException {
        HashSet<String> propNames = new HashSet<String>();
        for (SimpleString str : this.map.getPropertyNames()) {
            propNames.add(str.toString());
        }
        return Collections.enumeration(propNames);
    }

    public boolean itemExists(String name) throws JMSException {
        return this.map.containsProperty(new SimpleString(name));
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this.map.clear();
    }

    public void doBeforeSend() throws Exception {
        this.message.getBody().clear();
        this.map.encode(this.message.getBody());
        super.doBeforeSend();
    }

    public void doBeforeReceive() throws Exception {
        super.doBeforeReceive();
        this.map.decode(this.message.getBody());
    }

    private void checkName(String name) throws JMSException {
        this.checkWrite();
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null.");
        }
        if (name.equals("")) {
            throw new IllegalArgumentException("Name must not be an empty String.");
        }
    }
}

