/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import org.hornetq.core.client.ClientConsumer;
import org.hornetq.core.client.ClientMessage;
import org.hornetq.core.client.ClientSession;
import org.hornetq.core.exception.HornetQException;
import org.hornetq.core.logging.Logger;
import org.hornetq.jms.HornetQQueue;
import org.hornetq.jms.client.HornetQMessage;
import org.hornetq.jms.client.JMSExceptionHelper;
import org.hornetq.jms.client.SelectorTranslator;
import org.hornetq.utils.SimpleString;

public class HornetQQueueBrowser
implements QueueBrowser {
    private static final Logger log = Logger.getLogger(HornetQQueueBrowser.class);
    private static final long NEXT_MESSAGE_TIMEOUT = 1000L;
    private ClientSession session;
    private ClientConsumer consumer;
    private HornetQQueue queue;
    private SimpleString filterString;

    public HornetQQueueBrowser(HornetQQueue queue, String messageSelector, ClientSession session) throws JMSException {
        this.session = session;
        this.queue = queue;
        if (messageSelector != null) {
            this.filterString = new SimpleString(SelectorTranslator.convertToHornetQFilterString(messageSelector));
        }
    }

    public void close() throws JMSException {
        if (this.consumer != null) {
            try {
                this.consumer.close();
            }
            catch (HornetQException e) {
                throw JMSExceptionHelper.convertFromHornetQException(e);
            }
        }
    }

    public Enumeration getEnumeration() throws JMSException {
        try {
            this.close();
            this.consumer = this.session.createConsumer(this.queue.getSimpleAddress(), this.filterString, true);
            return new BrowserEnumeration();
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
    }

    public String getMessageSelector() throws JMSException {
        return this.filterString == null ? null : this.filterString.toString();
    }

    public Queue getQueue() throws JMSException {
        return this.queue;
    }

    public String toString() {
        return "HornetQQueueBrowser->" + this.consumer;
    }

    private class BrowserEnumeration
    implements Enumeration {
        ClientMessage current = null;

        private BrowserEnumeration() {
        }

        public boolean hasMoreElements() {
            if (this.current == null) {
                try {
                    this.current = HornetQQueueBrowser.this.consumer.receive(1000L);
                }
                catch (HornetQException e) {
                    return false;
                }
            }
            return this.current != null;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                ClientMessage next = this.current;
                this.current = null;
                HornetQMessage msg = HornetQMessage.createMessage(next, HornetQQueueBrowser.this.session);
                try {
                    msg.doBeforeReceive();
                }
                catch (Exception e) {
                    log.error((Object)"Failed to create message", (Throwable)e);
                    return null;
                }
                return msg;
            }
            throw new NoSuchElementException();
        }
    }
}

