/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import javax.jms.JMSException;
import javax.jms.Queue;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.logging.Logger;
import org.hornetq.jms.client.HornetQDestination;

public class HornetQQueue
extends HornetQDestination
implements Queue {
    private static final Logger log = Logger.getLogger(HornetQQueue.class);
    private static final long serialVersionUID = -1106092883162295462L;
    public static final String JMS_QUEUE_ADDRESS_PREFIX = "jms.queue.";

    public static SimpleString createAddressFromName(String name) {
        return new SimpleString(JMS_QUEUE_ADDRESS_PREFIX + name);
    }

    public HornetQQueue(String name) {
        super(JMS_QUEUE_ADDRESS_PREFIX + name, name);
    }

    protected HornetQQueue(String address, String name) {
        super(address, name);
    }

    public String getQueueName() throws JMSException {
        return this.name;
    }

    public boolean isTemporary() {
        return false;
    }

    public String toString() {
        return "HornetQQueue[" + this.name + "]";
    }
}

