/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.core.logging.Logger;
import org.hornetq.jms.client.HornetQDestination;
import org.hornetq.jms.client.HornetQMessage;
import org.hornetq.jms.client.JMSExceptionHelper;
import org.hornetq.jms.client.SelectorTranslator;

public class HornetQQueueBrowser
implements QueueBrowser {
    private static final Logger log = Logger.getLogger(HornetQQueueBrowser.class);
    private final ClientSession session;
    private ClientConsumer consumer;
    private final HornetQDestination queue;
    private SimpleString filterString;

    protected HornetQQueueBrowser(HornetQDestination queue, String messageSelector, ClientSession session) throws JMSException {
        this.session = session;
        this.queue = queue;
        if (messageSelector != null) {
            this.filterString = new SimpleString(SelectorTranslator.convertToHornetQFilterString(messageSelector));
        }
    }

    public void close() throws JMSException {
        if (this.consumer != null) {
            try {
                this.consumer.close();
            }
            catch (HornetQException e) {
                throw JMSExceptionHelper.convertFromHornetQException(e);
            }
        }
    }

    public Enumeration getEnumeration() throws JMSException {
        try {
            this.close();
            this.consumer = this.session.createConsumer(this.queue.getSimpleAddress(), this.filterString, true);
            return new BrowserEnumeration();
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
    }

    public String getMessageSelector() throws JMSException {
        return this.filterString == null ? null : this.filterString.toString();
    }

    public Queue getQueue() throws JMSException {
        return this.queue;
    }

    public String toString() {
        return "HornetQQueueBrowser->" + this.consumer;
    }

    private class BrowserEnumeration
    implements Enumeration {
        ClientMessage current = null;

        private BrowserEnumeration() {
        }

        public boolean hasMoreElements() {
            if (this.current == null) {
                try {
                    this.current = HornetQQueueBrowser.this.consumer.receiveImmediate();
                }
                catch (HornetQException e) {
                    return false;
                }
            }
            return this.current != null;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                ClientMessage next = this.current;
                this.current = null;
                HornetQMessage msg = HornetQMessage.createMessage(next, HornetQQueueBrowser.this.session);
                try {
                    msg.doBeforeReceive();
                }
                catch (Exception e) {
                    log.error((Object)"Failed to create message", (Throwable)e);
                    return null;
                }
                return msg;
            }
            throw new NoSuchElementException();
        }
    }
}

