/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.server.recovery;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.xa.XAResource;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.jms.server.HornetQJMSServerLogger;
import org.hornetq.jms.server.recovery.HornetQXAResourceWrapper;
import org.hornetq.jms.server.recovery.RecoveryDiscovery;
import org.hornetq.jms.server.recovery.XARecoveryConfig;
import org.hornetq.utils.Pair;
import org.jboss.tm.XAResourceRecovery;

public class HornetQRecoveryRegistry
implements XAResourceRecovery {
    private static final HornetQRecoveryRegistry theInstance = new HornetQRecoveryRegistry();
    private final ConcurrentHashMap<XARecoveryConfig, RecoveryDiscovery> configSet = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, HornetQXAResourceWrapper> recoveries = new ConcurrentHashMap();
    private final Set<RecoveryDiscovery> failedDiscoverySet = new HashSet<RecoveryDiscovery>();

    private HornetQRecoveryRegistry() {
    }

    public XAResource[] getXAResources() {
        try {
            this.checkFailures();
            XAResource[] resourceArray = new HornetQXAResourceWrapper[this.recoveries.size()];
            resourceArray = this.recoveries.values().toArray(resourceArray);
            if (HornetQJMSServerLogger.LOGGER.isDebugEnabled()) {
                HornetQJMSServerLogger.LOGGER.debug("\n=======================================================================================");
                HornetQJMSServerLogger.LOGGER.debug("Returning the following list on getXAREsources:");
                for (Map.Entry<String, HornetQXAResourceWrapper> entry : this.recoveries.entrySet()) {
                    HornetQJMSServerLogger.LOGGER.debug("server-id=" + entry.getKey() + ", value=" + entry.getValue());
                }
                HornetQJMSServerLogger.LOGGER.debug("=======================================================================================\n");
            }
            return resourceArray;
        }
        catch (Throwable e) {
            HornetQJMSServerLogger.LOGGER.warn(e.getMessage(), e);
            return new XAResource[0];
        }
    }

    public static HornetQRecoveryRegistry getInstance() {
        return theInstance;
    }

    public void register(XARecoveryConfig resourceConfig) {
        RecoveryDiscovery newInstance = new RecoveryDiscovery(resourceConfig);
        RecoveryDiscovery discoveryRecord = this.configSet.putIfAbsent(resourceConfig, newInstance);
        if (discoveryRecord == null) {
            discoveryRecord = newInstance;
            discoveryRecord.start(false);
        }
        discoveryRecord.incrementUsage();
    }

    public void unRegister(XARecoveryConfig resourceConfig) {
        RecoveryDiscovery discoveryRecord = this.configSet.get(resourceConfig);
        if (discoveryRecord != null && discoveryRecord.decrementUsage() == 0 && (discoveryRecord = this.configSet.remove(resourceConfig)) != null) {
            discoveryRecord.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failedDiscovery(RecoveryDiscovery failedDiscovery) {
        HornetQJMSServerLogger.LOGGER.debug("RecoveryDiscovery being set to restart:" + failedDiscovery);
        Set<RecoveryDiscovery> set = this.failedDiscoverySet;
        synchronized (set) {
            this.failedDiscoverySet.add(failedDiscovery);
        }
    }

    public void nodeUp(String nodeID, Pair<TransportConfiguration, TransportConfiguration> networkConfiguration, String username, String password) {
        if (this.recoveries.get(nodeID) == null) {
            if (HornetQJMSServerLogger.LOGGER.isDebugEnabled()) {
                HornetQJMSServerLogger.LOGGER.debug(nodeID + " being registered towards " + networkConfiguration);
            }
            XARecoveryConfig config = new XARecoveryConfig(true, this.extractTransportConfiguration(networkConfiguration), username, password);
            HornetQXAResourceWrapper wrapper = new HornetQXAResourceWrapper(config);
            this.recoveries.putIfAbsent(nodeID, wrapper);
        }
    }

    public void nodeDown(String nodeID) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFailures() {
        final HashSet<RecoveryDiscovery> failures = new HashSet<RecoveryDiscovery>();
        Set<RecoveryDiscovery> set = this.failedDiscoverySet;
        synchronized (set) {
            failures.addAll(this.failedDiscoverySet);
            this.failedDiscoverySet.clear();
        }
        if (failures.size() > 0) {
            Thread t = new Thread("HornetQ Recovery Discovery Reinitialization"){

                @Override
                public void run() {
                    for (RecoveryDiscovery discovery : failures) {
                        try {
                            HornetQJMSServerLogger.LOGGER.debug("Retrying discovery " + discovery);
                            discovery.start(true);
                        }
                        catch (Throwable e) {
                            HornetQJMSServerLogger.LOGGER.warn(e.getMessage(), e);
                        }
                    }
                }
            };
            t.start();
        }
    }

    private TransportConfiguration[] extractTransportConfiguration(Pair<TransportConfiguration, TransportConfiguration> networkConfiguration) {
        if (networkConfiguration.getB() != null) {
            return new TransportConfiguration[]{(TransportConfiguration)networkConfiguration.getA(), (TransportConfiguration)networkConfiguration.getB()};
        }
        return new TransportConfiguration[]{(TransportConfiguration)networkConfiguration.getA()};
    }
}

