/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.server;

import javax.management.ObjectName;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.jms.server.recovery.XARecoveryConfig;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Cause;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.MessageLogger;
import org.w3c.dom.Node;

@MessageLogger(projectCode="HQ")
public interface HornetQJMSServerLogger
extends BasicLogger {
    public static final HornetQJMSServerLogger LOGGER = (HornetQJMSServerLogger)Logger.getMessageLogger(HornetQJMSServerLogger.class, (String)HornetQJMSServerLogger.class.getPackage().getName());

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=121000, value="Failed to set up JMS bridge connections. Most probably the source or target servers are unavailable. Will retry after a pause of {0} ms", format=Message.Format.MESSAGE_FORMAT)
    public void failedToSetUpBridge(long var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=121001, value="JMS Bridge Succeeded in reconnecting to servers", format=Message.Format.MESSAGE_FORMAT)
    public void bridgeReconnected();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=121002, value="Succeeded in connecting to servers", format=Message.Format.MESSAGE_FORMAT)
    public void bridgeConnected();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=121003, value="JMS Server Manager Running cached command for {0}", format=Message.Format.MESSAGE_FORMAT)
    public void serverRunningCachedCommand(Runnable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=121004, value="JMS Server Manager Caching command for {0} since the JMS Server is not active yet", format=Message.Format.MESSAGE_FORMAT)
    public void serverCachingCommand(Object var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=121005, value="Invalid \"host\" value \"0.0.0.0\" detected for \"{0}\" connector. Switching to \"{1}\". If this new address is incorrect please manually configure the connector to use the proper one.", format=Message.Format.MESSAGE_FORMAT)
    public void invalidHostForConnector(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=122000, value="Attempt to start JMS Bridge, but is already started", format=Message.Format.MESSAGE_FORMAT)
    public void errorBridgeAlreadyStarted();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=122001, value="Failed to start JMS Bridge", format=Message.Format.MESSAGE_FORMAT)
    public void errorStartingBridge();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=122002, value="Failed to unregisted JMS Bridge {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorUnregisteringBridge(ObjectName var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=122003, value="JMS Bridge unable to set up connections, bridge will be stopped", format=Message.Format.MESSAGE_FORMAT)
    public void errorConnectingBridge();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=122004, value="JMS Bridge Will retry after a pause of {0} ms", format=Message.Format.MESSAGE_FORMAT)
    public void bridgeRetry(long var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=122005, value="JMS Bridge unable to set up connections, bridge will not be started", format=Message.Format.MESSAGE_FORMAT)
    public void bridgeNotStarted();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=122006, value="Detected failure on bridge connection", format=Message.Format.MESSAGE_FORMAT)
    public void bridgeFailure();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=122007, value="Queue {0} does not exist on the topic {1}. It was deleted manually probably.", format=Message.Format.MESSAGE_FORMAT)
    public void noQueueOnTopic(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=122008, value="XA Recovery can not connect to any hornetq server on recovery {0}", format=Message.Format.MESSAGE_FORMAT)
    public void recoveryConnectFailed(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=122009, value="JMS Bridge failed to send + acknowledge batch, closing JMS objects", format=Message.Format.MESSAGE_FORMAT)
    public void bridgeAckError(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=122010, value="Failed to connect JMS Bridge", format=Message.Format.MESSAGE_FORMAT)
    public void bridgeConnectError(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=122011, value="error unbinding {0} from JNDI", format=Message.Format.MESSAGE_FORMAT)
    public void jndiUnbindError(@Cause Exception var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=122012, value="JMS Server Manager error", format=Message.Format.MESSAGE_FORMAT)
    public void jmsServerError(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=122013, value="Error in XA Recovery recover", format=Message.Format.MESSAGE_FORMAT)
    public void xaRecoverError(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=122014, value="Notified of connection failure in xa recovery connectionFactory for provider {0} will attempt reconnect on next pass", format=Message.Format.MESSAGE_FORMAT)
    public void xaRecoverConnectionError(@Cause Exception var1, ClientSessionFactory var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=122015, value="Can not connect to {0} on auto-generated resource recovery", format=Message.Format.MESSAGE_FORMAT)
    public void xaRecoverAutoConnectionError(@Cause Throwable var1, XARecoveryConfig var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=122016, value="Error in XA Recovery", format=Message.Format.MESSAGE_FORMAT)
    public void xaRecoveryError(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=122017, value="Tried to correct invalid \"host\" value \"0.0.0.0\" for \"{0}\" connector, but received an exception.", format=Message.Format.MESSAGE_FORMAT)
    public void failedToCorrectHost(@Cause Exception var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=122018, value="Could not start recovery discovery on {0}, we will retry every recovery scan until the server is available", format=Message.Format.MESSAGE_FORMAT)
    public void xaRecoveryStartError(XARecoveryConfig var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=124000, value="key attribute missing for JMS configuration {0}", format=Message.Format.MESSAGE_FORMAT)
    public void jmsConfigMissingKey(Node var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=124001, value="Failed to start source connection", format=Message.Format.MESSAGE_FORMAT)
    public void jmsBridgeSrcConnectError(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=124002, value="Failed to start JMS deployer", format=Message.Format.MESSAGE_FORMAT)
    public void jmsDeployerStartError(@Cause Exception var1);
}

