/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.management.impl;

import java.util.Map;
import javax.management.MBeanInfo;
import javax.management.StandardMBean;
import org.hornetq.api.core.FilterConstants;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.management.MessageCounterInfo;
import org.hornetq.api.core.management.Operation;
import org.hornetq.api.core.management.QueueControl;
import org.hornetq.api.jms.management.JMSQueueControl;
import org.hornetq.core.management.impl.MBeanInfoHelper;
import org.hornetq.core.messagecounter.MessageCounter;
import org.hornetq.core.messagecounter.impl.MessageCounterHelper;
import org.hornetq.jms.client.HornetQDestination;
import org.hornetq.jms.client.HornetQMessage;
import org.hornetq.jms.client.HornetQQueue;
import org.hornetq.jms.client.SelectorTranslator;
import org.hornetq.jms.server.JMSServerManager;
import org.hornetq.utils.json.JSONArray;
import org.hornetq.utils.json.JSONObject;

public class JMSQueueControlImpl
extends StandardMBean
implements JMSQueueControl {
    private final HornetQDestination managedQueue;
    private final JMSServerManager jmsServerManager;
    private final QueueControl coreQueueControl;
    private final MessageCounter counter;

    public static String createFilterFromJMSSelector(String selectorStr) throws HornetQException {
        return selectorStr == null || selectorStr.trim().length() == 0 ? null : SelectorTranslator.convertToHornetQFilterString((String)selectorStr);
    }

    private static String createFilterForJMSMessageID(String jmsMessageID) throws Exception {
        return FilterConstants.HORNETQ_USERID + " = '" + jmsMessageID + "'";
    }

    static String toJSON(Map<String, Object>[] messages) {
        JSONArray array = new JSONArray();
        for (Map<String, Object> message : messages) {
            array.put((Object)new JSONObject(message));
        }
        return array.toString();
    }

    public JMSQueueControlImpl(HornetQDestination managedQueue, QueueControl coreQueueControl, JMSServerManager jmsServerManager, MessageCounter counter) throws Exception {
        super(JMSQueueControl.class);
        this.managedQueue = managedQueue;
        this.jmsServerManager = jmsServerManager;
        this.coreQueueControl = coreQueueControl;
        this.counter = counter;
    }

    public String getName() {
        return this.managedQueue.getName();
    }

    public String getAddress() {
        return this.managedQueue.getAddress();
    }

    public boolean isTemporary() {
        return this.managedQueue.isTemporary();
    }

    public long getMessageCount() {
        return this.coreQueueControl.getMessageCount();
    }

    public long getMessagesAdded() {
        return this.coreQueueControl.getMessagesAdded();
    }

    public int getConsumerCount() {
        return this.coreQueueControl.getConsumerCount();
    }

    public int getDeliveringCount() {
        return this.coreQueueControl.getDeliveringCount();
    }

    public long getScheduledCount() {
        return this.coreQueueControl.getScheduledCount();
    }

    public boolean isDurable() {
        return this.coreQueueControl.isDurable();
    }

    public String getDeadLetterAddress() {
        return this.coreQueueControl.getDeadLetterAddress();
    }

    public void setDeadLetterAddress(String deadLetterAddress) throws Exception {
        this.coreQueueControl.setDeadLetterAddress(deadLetterAddress);
    }

    public String getExpiryAddress() {
        return this.coreQueueControl.getExpiryAddress();
    }

    public void setExpiryAddress(String expiryAddress) throws Exception {
        this.coreQueueControl.setExpiryAddress(expiryAddress);
    }

    public void addJNDI(String jndi) throws Exception {
        this.jmsServerManager.addQueueToJndi(this.managedQueue.getName(), jndi);
    }

    public void removeJNDI(String jndi) throws Exception {
        this.jmsServerManager.removeQueueFromJNDI(this.managedQueue.getName(), jndi);
    }

    public String[] getJNDIBindings() {
        return this.jmsServerManager.getJNDIOnQueue(this.managedQueue.getName());
    }

    public boolean removeMessage(String messageID) throws Exception {
        String filter = JMSQueueControlImpl.createFilterForJMSMessageID(messageID);
        int removed = this.coreQueueControl.removeMessages(filter);
        if (removed != 1) {
            throw new IllegalArgumentException("No message found for JMSMessageID: " + messageID);
        }
        return true;
    }

    public int removeMessages(String filterStr) throws Exception {
        String filter = JMSQueueControlImpl.createFilterFromJMSSelector(filterStr);
        return this.coreQueueControl.removeMessages(filter);
    }

    public Map<String, Object>[] listMessages(String filterStr) throws Exception {
        try {
            String filter = JMSQueueControlImpl.createFilterFromJMSSelector(filterStr);
            Map[] coreMessages = this.coreQueueControl.listMessages(filter);
            Map[] jmsMessages = new Map[coreMessages.length];
            int i = 0;
            for (Map coreMessage : coreMessages) {
                Map jmsMessage = HornetQMessage.coreMaptoJMSMap((Map)coreMessage);
                jmsMessages[i++] = jmsMessage;
            }
            return jmsMessages;
        }
        catch (HornetQException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public String listMessagesAsJSON(String filter) throws Exception {
        return JMSQueueControlImpl.toJSON(this.listMessages(filter));
    }

    public long countMessages(String filterStr) throws Exception {
        String filter = JMSQueueControlImpl.createFilterFromJMSSelector(filterStr);
        return this.coreQueueControl.countMessages(filter);
    }

    public boolean expireMessage(String messageID) throws Exception {
        String filter = JMSQueueControlImpl.createFilterForJMSMessageID(messageID);
        int expired = this.coreQueueControl.expireMessages(filter);
        if (expired != 1) {
            throw new IllegalArgumentException("No message found for JMSMessageID: " + messageID);
        }
        return true;
    }

    public int expireMessages(String filterStr) throws Exception {
        String filter = JMSQueueControlImpl.createFilterFromJMSSelector(filterStr);
        return this.coreQueueControl.expireMessages(filter);
    }

    public boolean sendMessageToDeadLetterAddress(String messageID) throws Exception {
        String filter = JMSQueueControlImpl.createFilterForJMSMessageID(messageID);
        int dead = this.coreQueueControl.sendMessagesToDeadLetterAddress(filter);
        if (dead != 1) {
            throw new IllegalArgumentException("No message found for JMSMessageID: " + messageID);
        }
        return true;
    }

    public int sendMessagesToDeadLetterAddress(String filterStr) throws Exception {
        String filter = JMSQueueControlImpl.createFilterFromJMSSelector(filterStr);
        return this.coreQueueControl.sendMessagesToDeadLetterAddress(filter);
    }

    public boolean changeMessagePriority(String messageID, int newPriority) throws Exception {
        String filter = JMSQueueControlImpl.createFilterForJMSMessageID(messageID);
        int changed = this.coreQueueControl.changeMessagesPriority(filter, newPriority);
        if (changed != 1) {
            throw new IllegalArgumentException("No message found for JMSMessageID: " + messageID);
        }
        return true;
    }

    public int changeMessagesPriority(String filterStr, int newPriority) throws Exception {
        String filter = JMSQueueControlImpl.createFilterFromJMSSelector(filterStr);
        return this.coreQueueControl.changeMessagesPriority(filter, newPriority);
    }

    public boolean moveMessage(String messageID, String otherQueueName) throws Exception {
        return this.moveMessage(messageID, otherQueueName, false);
    }

    public boolean moveMessage(String messageID, String otherQueueName, boolean rejectDuplicates) throws Exception {
        HornetQQueue otherQueue;
        String filter = JMSQueueControlImpl.createFilterForJMSMessageID(messageID);
        int moved = this.coreQueueControl.moveMessages(filter, (otherQueue = HornetQDestination.createQueue((String)otherQueueName)).getAddress(), rejectDuplicates);
        if (moved != 1) {
            throw new IllegalArgumentException("No message found for JMSMessageID: " + messageID);
        }
        return true;
    }

    public int moveMessages(String filterStr, String otherQueueName, boolean rejectDuplicates) throws Exception {
        String filter = JMSQueueControlImpl.createFilterFromJMSSelector(filterStr);
        HornetQQueue otherQueue = HornetQDestination.createQueue((String)otherQueueName);
        return this.coreQueueControl.moveMessages(filter, otherQueue.getAddress(), rejectDuplicates);
    }

    public int moveMessages(String filterStr, String otherQueueName) throws Exception {
        return this.moveMessages(filterStr, otherQueueName, false);
    }

    @Operation(desc="List all the existent consumers on the Queue")
    public String listConsumersAsJSON() throws Exception {
        return this.coreQueueControl.listConsumersAsJSON();
    }

    public String listMessageCounter() {
        try {
            return MessageCounterInfo.toJSon((MessageCounter)this.counter);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void resetMessageCounter() throws Exception {
        this.coreQueueControl.resetMessageCounter();
    }

    public String listMessageCounterAsHTML() {
        return MessageCounterHelper.listMessageCounterAsHTML((MessageCounter[])new MessageCounter[]{this.counter});
    }

    public String listMessageCounterHistory() throws Exception {
        return MessageCounterHelper.listMessageCounterHistory((MessageCounter)this.counter);
    }

    public String listMessageCounterHistoryAsHTML() {
        return MessageCounterHelper.listMessageCounterHistoryAsHTML((MessageCounter[])new MessageCounter[]{this.counter});
    }

    public boolean isPaused() throws Exception {
        return this.coreQueueControl.isPaused();
    }

    public void pause() throws Exception {
        this.coreQueueControl.pause();
    }

    public void resume() throws Exception {
        this.coreQueueControl.resume();
    }

    public String getSelector() {
        return this.coreQueueControl.getFilter();
    }

    public void flushExecutor() {
        this.coreQueueControl.flushExecutor();
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo info = super.getMBeanInfo();
        return new MBeanInfo(info.getClassName(), info.getDescription(), info.getAttributes(), info.getConstructors(), MBeanInfoHelper.getMBeanOperationsInfo(JMSQueueControl.class), info.getNotifications());
    }
}

