/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.server.impl;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.hornetq.core.server.ActivateCallback;
import org.hornetq.core.server.HornetQComponent;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.HornetQServerLogger;
import org.jnp.server.Main;
import org.jnp.server.NamingBean;
import org.jnp.server.NamingBeanImpl;

public class StandaloneNamingServer
implements HornetQComponent {
    private Main jndiServer;
    private HornetQServer server;
    private NamingBeanImpl namingBean;
    private int port = 1099;
    private String bindAddress = "localhost";
    private int rmiPort = 1098;
    private String rmiBindAddress = "localhost";
    private ExecutorService executor;

    public StandaloneNamingServer(HornetQServer server) {
        this.server = server;
    }

    public void start() throws Exception {
        this.server.registerActivateCallback((ActivateCallback)new ServerActivateCallback());
    }

    public void stop() throws Exception {
    }

    public boolean isStarted() {
        return false;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public void setRmiPort(int rmiPort) {
        this.rmiPort = rmiPort;
    }

    public void setRmiBindAddress(String rmiBindAddress) {
        this.rmiBindAddress = rmiBindAddress;
    }

    private class ServerActivateCallback
    implements ActivateCallback {
        private boolean activated = false;

        private ServerActivateCallback() {
        }

        public synchronized void preActivate() {
            if (this.activated) {
                return;
            }
            try {
                StandaloneNamingServer.this.jndiServer = new Main();
                StandaloneNamingServer.this.namingBean = new NamingBeanImpl();
                StandaloneNamingServer.this.jndiServer.setNamingInfo((NamingBean)StandaloneNamingServer.this.namingBean);
                StandaloneNamingServer.this.executor = Executors.newCachedThreadPool();
                StandaloneNamingServer.this.jndiServer.setLookupExector((Executor)StandaloneNamingServer.this.executor);
                StandaloneNamingServer.this.jndiServer.setPort(StandaloneNamingServer.this.port);
                StandaloneNamingServer.this.jndiServer.setBindAddress(StandaloneNamingServer.this.bindAddress);
                StandaloneNamingServer.this.jndiServer.setRmiPort(StandaloneNamingServer.this.rmiPort);
                StandaloneNamingServer.this.jndiServer.setRmiBindAddress(StandaloneNamingServer.this.rmiBindAddress);
                StandaloneNamingServer.this.namingBean.start();
                StandaloneNamingServer.this.jndiServer.start();
            }
            catch (Exception e) {
                HornetQServerLogger.LOGGER.unableToStartNamingServer(e);
            }
            this.activated = true;
        }

        public void activated() {
        }

        public synchronized void deActivate() {
            if (!this.activated) {
                return;
            }
            if (StandaloneNamingServer.this.jndiServer != null) {
                try {
                    StandaloneNamingServer.this.jndiServer.stop();
                }
                catch (Exception e) {
                    HornetQServerLogger.LOGGER.unableToStopNamingServer(e);
                }
            }
            if (StandaloneNamingServer.this.namingBean != null) {
                StandaloneNamingServer.this.namingBean.stop();
            }
            if (StandaloneNamingServer.this.executor != null) {
                StandaloneNamingServer.this.executor.shutdown();
            }
            this.activated = false;
        }

        public void activationComplete() {
        }
    }
}

