/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.server.recovery;

import java.util.concurrent.atomic.AtomicInteger;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQExceptionType;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClusterTopologyListener;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.api.core.client.SessionFailureListener;
import org.hornetq.api.core.client.TopologyMember;
import org.hornetq.core.client.impl.ClientSessionFactoryInternal;
import org.hornetq.jms.server.HornetQJMSServerLogger;
import org.hornetq.jms.server.recovery.HornetQRecoveryRegistry;
import org.hornetq.jms.server.recovery.XARecoveryConfig;

public class RecoveryDiscovery
implements SessionFailureListener {
    private ServerLocator locator;
    private ClientSessionFactoryInternal sessionFactory;
    private final XARecoveryConfig config;
    private final AtomicInteger usage = new AtomicInteger(0);
    private boolean started = false;

    public RecoveryDiscovery(XARecoveryConfig config) {
        this.config = config;
    }

    public synchronized void start(boolean retry) {
        if (!this.started) {
            HornetQJMSServerLogger.LOGGER.debug("Starting RecoveryDiscovery on " + this.config);
            this.started = true;
            this.locator = this.config.createServerLocator();
            this.locator.disableFinalizeCheck();
            this.locator.addClusterTopologyListener((ClusterTopologyListener)new InternalListener(this.config));
            try {
                this.sessionFactory = (ClientSessionFactoryInternal)this.locator.createSessionFactory();
                this.sessionFactory.addFailureListener((SessionFailureListener)this);
                HornetQJMSServerLogger.LOGGER.debug("RecoveryDiscovery started fine on " + this.config);
            }
            catch (Exception startupError) {
                if (!retry) {
                    HornetQJMSServerLogger.LOGGER.xaRecoveryStartError(this.config);
                }
                this.stop();
                HornetQRecoveryRegistry.getInstance().failedDiscovery(this);
            }
        }
    }

    public synchronized void stop() {
        this.internalStop();
    }

    public int incrementUsage() {
        return this.usage.decrementAndGet();
    }

    public int decrementUsage() {
        return this.usage.incrementAndGet();
    }

    protected void finalize() {
        this.internalStop();
    }

    protected void internalStop() {
        if (this.started) {
            this.started = false;
            try {
                if (this.sessionFactory != null) {
                    this.sessionFactory.close();
                }
            }
            catch (Exception ignored) {
                HornetQJMSServerLogger.LOGGER.debug(ignored, ignored);
            }
            try {
                this.locator.close();
            }
            catch (Exception ignored) {
                HornetQJMSServerLogger.LOGGER.debug(ignored, ignored);
            }
            this.sessionFactory = null;
            this.locator = null;
        }
    }

    public void connectionFailed(HornetQException exception, boolean failedOver) {
        if (exception.getType() == HornetQExceptionType.DISCONNECTED) {
            HornetQJMSServerLogger.LOGGER.warn("being disconnected for server shutdown", (Throwable)exception);
        } else {
            HornetQJMSServerLogger.LOGGER.warn("Notified of connection failure in xa discovery, we will retry on the next recovery", (Throwable)exception);
        }
        this.internalStop();
        HornetQRecoveryRegistry.getInstance().failedDiscovery(this);
    }

    public void connectionFailed(HornetQException me, boolean failedOver, String scaleDownTargetNodeID) {
        this.connectionFailed(me, failedOver);
    }

    public void beforeReconnect(HornetQException exception) {
    }

    public String toString() {
        return "RecoveryDiscovery [config=" + this.config + ", started=" + this.started + "]";
    }

    public int hashCode() {
        return this.config.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof RecoveryDiscovery)) {
            return false;
        }
        RecoveryDiscovery discovery = (RecoveryDiscovery)o;
        return this.config.equals(discovery.config);
    }

    static final class InternalListener
    implements ClusterTopologyListener {
        private final XARecoveryConfig config;

        public InternalListener(XARecoveryConfig config) {
            this.config = config;
        }

        public void nodeUP(TopologyMember topologyMember, boolean last) {
            if (topologyMember.getLive() != null) {
                Pair connector = new Pair((Object)topologyMember.getLive(), (Object)topologyMember.getBackup());
                HornetQRecoveryRegistry.getInstance().nodeUp(topologyMember.getNodeId(), (Pair<TransportConfiguration, TransportConfiguration>)connector, this.config.getUsername(), this.config.getPassword());
            }
        }

        public void nodeDown(long eventUID, String nodeID) {
        }
    }
}

