/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import org.hornetq.core.client.ClientMessage;
import org.hornetq.core.client.ClientSession;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.remoting.spi.HornetQBuffer;
import org.hornetq.jms.client.HornetQMessage;

public class HornetQBytesMessage
extends HornetQMessage
implements BytesMessage {
    private static final Logger log = Logger.getLogger(HornetQBytesMessage.class);
    public static final byte TYPE = 4;

    public HornetQBytesMessage() {
        super((byte)4);
    }

    public HornetQBytesMessage(ClientSession session) {
        super((byte)4, session);
    }

    public HornetQBytesMessage(ClientMessage message, ClientSession session) {
        super(message, session);
    }

    public HornetQBytesMessage(BytesMessage foreign, ClientSession session) throws JMSException {
        super((Message)foreign, (byte)4, session);
        foreign.reset();
        byte[] buffer = new byte[1024];
        int n = foreign.readBytes(buffer);
        while (n != -1) {
            this.writeBytes(buffer, 0, n);
            n = foreign.readBytes(buffer);
        }
    }

    public boolean readBoolean() throws JMSException {
        this.checkRead();
        try {
            return this.getBody().readBoolean();
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public byte readByte() throws JMSException {
        this.checkRead();
        try {
            return this.getBody().readByte();
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public int readUnsignedByte() throws JMSException {
        this.checkRead();
        try {
            return this.getBody().readUnsignedByte();
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public short readShort() throws JMSException {
        this.checkRead();
        try {
            return this.getBody().readShort();
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public int readUnsignedShort() throws JMSException {
        this.checkRead();
        try {
            return this.getBody().readUnsignedShort();
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public char readChar() throws JMSException {
        this.checkRead();
        try {
            return this.getBody().readChar();
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public int readInt() throws JMSException {
        this.checkRead();
        try {
            return this.getBody().readInt();
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public long readLong() throws JMSException {
        this.checkRead();
        try {
            return this.getBody().readLong();
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public float readFloat() throws JMSException {
        this.checkRead();
        try {
            return this.getBody().readFloat();
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public double readDouble() throws JMSException {
        this.checkRead();
        try {
            return this.getBody().readDouble();
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public String readUTF() throws JMSException {
        this.checkRead();
        try {
            return this.getBody().readUTF();
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
        catch (Exception e) {
            JMSException je = new JMSException("Failed to get UTF");
            je.setLinkedException(e);
            throw je;
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        return this.readBytes(value, value.length);
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        this.checkRead();
        if (!this.getBody().readable()) {
            return -1;
        }
        int read = Math.min(length, this.getBody().readableBytes());
        if (read != 0) {
            this.getBody().readBytes(value, 0, read);
        }
        return read;
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.checkWrite();
        this.getBody().writeBoolean(value);
    }

    public void writeByte(byte value) throws JMSException {
        this.checkWrite();
        this.getBody().writeByte(value);
    }

    public void writeShort(short value) throws JMSException {
        this.checkWrite();
        this.getBody().writeShort(value);
    }

    public void writeChar(char value) throws JMSException {
        this.checkWrite();
        this.getBody().writeChar(value);
    }

    public void writeInt(int value) throws JMSException {
        this.checkWrite();
        this.getBody().writeInt(value);
    }

    public void writeLong(long value) throws JMSException {
        this.checkWrite();
        this.getBody().writeLong(value);
    }

    public void writeFloat(float value) throws JMSException {
        this.checkWrite();
        this.getBody().writeFloat(value);
    }

    public void writeDouble(double value) throws JMSException {
        this.checkWrite();
        this.getBody().writeDouble(value);
    }

    public void writeUTF(String value) throws JMSException {
        this.checkWrite();
        try {
            this.getBody().writeUTF(value);
        }
        catch (Exception e) {
            JMSException je = new JMSException("Failed to write UTF");
            je.setLinkedException(e);
            throw je;
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.checkWrite();
        this.getBody().writeBytes(value);
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.checkWrite();
        this.getBody().writeBytes(value, offset, length);
    }

    public void writeObject(Object value) throws JMSException {
        if (value == null) {
            throw new NullPointerException("Attempt to write a null value");
        }
        if (value instanceof String) {
            this.writeUTF((String)value);
        } else if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else {
            throw new MessageFormatException("Invalid object for properties");
        }
    }

    public void reset() throws JMSException {
        if (!this.readOnly) {
            this.readOnly = true;
            this.getBody().resetReaderIndex();
        } else {
            this.getBody().resetReaderIndex();
        }
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        HornetQBuffer currentBody = this.message.getBody();
        currentBody.clear();
    }

    public long getBodyLength() throws JMSException {
        this.checkRead();
        return this.message.getLargeBodySize();
    }

    public void doBeforeSend() throws Exception {
        this.reset();
    }

    public byte getType() {
        return 4;
    }
}

