/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.StreamMessage;
import org.hornetq.core.client.ClientMessage;
import org.hornetq.core.client.ClientSession;
import org.hornetq.core.logging.Logger;
import org.hornetq.jms.client.HornetQMessage;

public class HornetQStreamMessage
extends HornetQMessage
implements StreamMessage {
    private static final Logger log = Logger.getLogger(HornetQStreamMessage.class);
    public static final byte TYPE = 6;
    private int len;

    public HornetQStreamMessage() {
        super((byte)6);
    }

    public HornetQStreamMessage(ClientSession session) {
        super((byte)6, session);
    }

    public HornetQStreamMessage(ClientMessage message, ClientSession session) {
        super(message, session);
    }

    public HornetQStreamMessage(StreamMessage foreign, ClientSession session) throws JMSException {
        super((Message)foreign, (byte)6, session);
        foreign.reset();
        try {
            while (true) {
                Object obj = foreign.readObject();
                this.writeObject(obj);
            }
        }
        catch (MessageEOFException messageEOFException) {
            return;
        }
    }

    public byte getType() {
        return 6;
    }

    public boolean readBoolean() throws JMSException {
        this.checkRead();
        try {
            byte type = this.getBody().readByte();
            switch (type) {
                case 2: {
                    return this.getBody().readBoolean();
                }
                case 10: {
                    String s = this.getBody().readNullableString();
                    return Boolean.valueOf(s);
                }
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public byte readByte() throws JMSException {
        this.checkRead();
        try {
            byte type = this.getBody().readByte();
            switch (type) {
                case 3: {
                    return this.getBody().readByte();
                }
                case 10: {
                    String s = this.getBody().readNullableString();
                    return Byte.parseByte(s);
                }
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public short readShort() throws JMSException {
        this.checkRead();
        try {
            byte type = this.getBody().readByte();
            switch (type) {
                case 3: {
                    return this.getBody().readByte();
                }
                case 5: {
                    return this.getBody().readShort();
                }
                case 10: {
                    String s = this.getBody().readNullableString();
                    return Short.parseShort(s);
                }
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public char readChar() throws JMSException {
        this.checkRead();
        try {
            byte type = this.getBody().readByte();
            switch (type) {
                case 11: {
                    return this.getBody().readChar();
                }
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public int readInt() throws JMSException {
        this.checkRead();
        try {
            byte type = this.getBody().readByte();
            switch (type) {
                case 3: {
                    return this.getBody().readByte();
                }
                case 5: {
                    return this.getBody().readShort();
                }
                case 6: {
                    return this.getBody().readInt();
                }
                case 10: {
                    String s = this.getBody().readNullableString();
                    return Integer.parseInt(s);
                }
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public long readLong() throws JMSException {
        this.checkRead();
        try {
            byte type = this.getBody().readByte();
            switch (type) {
                case 3: {
                    return this.getBody().readByte();
                }
                case 5: {
                    return this.getBody().readShort();
                }
                case 6: {
                    return this.getBody().readInt();
                }
                case 7: {
                    return this.getBody().readLong();
                }
                case 10: {
                    String s = this.getBody().readNullableString();
                    return Long.parseLong(s);
                }
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public float readFloat() throws JMSException {
        this.checkRead();
        try {
            byte type = this.getBody().readByte();
            switch (type) {
                case 8: {
                    return this.getBody().readFloat();
                }
                case 10: {
                    String s = this.getBody().readNullableString();
                    return Float.parseFloat(s);
                }
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public double readDouble() throws JMSException {
        this.checkRead();
        try {
            byte type = this.getBody().readByte();
            switch (type) {
                case 8: {
                    return this.getBody().readFloat();
                }
                case 9: {
                    return this.getBody().readDouble();
                }
                case 10: {
                    String s = this.getBody().readNullableString();
                    return Double.parseDouble(s);
                }
            }
            throw new MessageFormatException("Invalid conversion: " + type);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public String readString() throws JMSException {
        this.checkRead();
        try {
            byte type = this.getBody().readByte();
            switch (type) {
                case 2: {
                    return String.valueOf(this.getBody().readBoolean());
                }
                case 3: {
                    return String.valueOf(this.getBody().readByte());
                }
                case 5: {
                    return String.valueOf(this.getBody().readShort());
                }
                case 11: {
                    return String.valueOf(this.getBody().readChar());
                }
                case 6: {
                    return String.valueOf(this.getBody().readInt());
                }
                case 7: {
                    return String.valueOf(this.getBody().readLong());
                }
                case 8: {
                    return String.valueOf(this.getBody().readFloat());
                }
                case 9: {
                    return String.valueOf(this.getBody().readDouble());
                }
                case 10: {
                    return this.getBody().readNullableString();
                }
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        this.checkRead();
        try {
            if (this.len == -1) {
                this.len = 0;
                return -1;
            }
            if (this.len == 0) {
                byte type = this.getBody().readByte();
                if (type != 4) {
                    throw new MessageFormatException("Invalid conversion");
                }
                this.len = this.getBody().readInt();
            }
            int read = Math.min(value.length, this.len);
            this.getBody().readBytes(value, 0, read);
            this.len -= read;
            if (this.len == 0) {
                this.len = -1;
            }
            return read;
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public Object readObject() throws JMSException {
        this.checkRead();
        byte type = this.getBody().readByte();
        switch (type) {
            case 2: {
                return this.getBody().readBoolean();
            }
            case 3: {
                return this.getBody().readByte();
            }
            case 5: {
                return this.getBody().readShort();
            }
            case 11: {
                return Character.valueOf(this.getBody().readChar());
            }
            case 6: {
                return this.getBody().readInt();
            }
            case 7: {
                return this.getBody().readLong();
            }
            case 8: {
                return Float.valueOf(this.getBody().readFloat());
            }
            case 9: {
                return this.getBody().readDouble();
            }
            case 10: {
                return this.getBody().readNullableString();
            }
            case 4: {
                int len = this.getBody().readInt();
                byte[] bytes = new byte[len];
                this.getBody().readBytes(bytes);
                return bytes;
            }
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.checkWrite();
        this.getBody().writeByte((byte)2);
        this.getBody().writeBoolean(value);
    }

    public void writeByte(byte value) throws JMSException {
        this.checkWrite();
        this.getBody().writeByte((byte)3);
        this.getBody().writeByte(value);
    }

    public void writeShort(short value) throws JMSException {
        this.checkWrite();
        this.getBody().writeByte((byte)5);
        this.getBody().writeShort(value);
    }

    public void writeChar(char value) throws JMSException {
        this.checkWrite();
        this.getBody().writeByte((byte)11);
        this.getBody().writeChar(value);
    }

    public void writeInt(int value) throws JMSException {
        this.checkWrite();
        this.getBody().writeByte((byte)6);
        this.getBody().writeInt(value);
    }

    public void writeLong(long value) throws JMSException {
        this.checkWrite();
        this.getBody().writeByte((byte)7);
        this.getBody().writeLong(value);
    }

    public void writeFloat(float value) throws JMSException {
        this.checkWrite();
        this.getBody().writeByte((byte)8);
        this.getBody().writeFloat(value);
    }

    public void writeDouble(double value) throws JMSException {
        this.checkWrite();
        this.getBody().writeByte((byte)9);
        this.getBody().writeDouble(value);
    }

    public void writeString(String value) throws JMSException {
        this.checkWrite();
        this.getBody().writeByte((byte)10);
        this.getBody().writeNullableString(value);
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.checkWrite();
        this.getBody().writeByte((byte)4);
        this.getBody().writeInt(value.length);
        this.getBody().writeBytes(value);
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.checkWrite();
        this.getBody().writeByte((byte)4);
        this.getBody().writeInt(length);
        this.getBody().writeBytes(value, offset, length);
    }

    public void writeObject(Object value) throws JMSException {
        if (value == null) {
            throw new NullPointerException("Attempt to write a null value");
        }
        if (value instanceof String) {
            this.writeString((String)value);
        } else if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else {
            throw new MessageFormatException("Invalid object type: " + value.getClass());
        }
    }

    public void reset() throws JMSException {
        if (!this.readOnly) {
            this.readOnly = true;
        }
        this.getBody().resetReaderIndex();
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this.message.getBody().clear();
    }

    public void doBeforeSend() throws Exception {
        this.reset();
    }
}

