/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.server.impl;

import java.util.ArrayList;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.TransportConfiguration;
import org.hornetq.core.config.cluster.DiscoveryGroupConfiguration;
import org.hornetq.core.config.impl.Validators;
import org.hornetq.core.deployers.DeploymentManager;
import org.hornetq.core.deployers.impl.XmlDeployer;
import org.hornetq.core.logging.Logger;
import org.hornetq.jms.server.JMSServerManager;
import org.hornetq.utils.Pair;
import org.hornetq.utils.XMLConfigurationUtil;
import org.hornetq.utils.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JMSServerDeployer
extends XmlDeployer {
    private static final Logger log = Logger.getLogger(JMSServerDeployer.class);
    private final Configuration configuration;
    private JMSServerManager jmsServerControl;
    private static final String CONNECTOR_REF_ELEMENT = "connector-ref";
    private static final String DISCOVERY_GROUP_ELEMENT = "discovery-group-ref";
    private static final String ENTRIES_NODE_NAME = "entries";
    private static final String ENTRY_NODE_NAME = "entry";
    private static final String CONNECTION_FACTORY_NODE_NAME = "connection-factory";
    private static final String QUEUE_NODE_NAME = "queue";
    private static final String QUEUE_SELECTOR_NODE_NAME = "selector";
    private static final String TOPIC_NODE_NAME = "topic";
    private static final boolean DEFAULT_QUEUE_DURABILITY = true;

    public JMSServerDeployer(JMSServerManager jmsServerManager, DeploymentManager deploymentManager, Configuration config) {
        super(deploymentManager);
        this.jmsServerControl = jmsServerManager;
        this.configuration = config;
    }

    public String[] getElementTagName() {
        return new String[]{QUEUE_NODE_NAME, TOPIC_NODE_NAME, CONNECTION_FACTORY_NODE_NAME};
    }

    public void validate(Node rootNode) throws Exception {
        XMLUtil.validate((Node)rootNode, (String)"schema/hornetq-jms.xsd");
    }

    public void deploy(Node node) throws Exception {
        this.createAndBindObject(node);
    }

    private void createAndBindObject(Node node) throws Exception {
        block14: {
            block15: {
                block13: {
                    if (!node.getNodeName().equals(CONNECTION_FACTORY_NODE_NAME)) break block13;
                    Element e = (Element)node;
                    long clientFailureCheckPeriod = XMLConfigurationUtil.getLong((Element)e, (String)"client-failure-check-period", (long)30000L, (Validators.Validator)Validators.MINUS_ONE_OR_GT_ZERO);
                    long connectionTTL = XMLConfigurationUtil.getLong((Element)e, (String)"connection-ttl", (long)300000L, (Validators.Validator)Validators.MINUS_ONE_OR_GE_ZERO);
                    long callTimeout = XMLConfigurationUtil.getLong((Element)e, (String)"call-timeout", (long)30000L, (Validators.Validator)Validators.GE_ZERO);
                    String clientID = XMLConfigurationUtil.getString((Element)e, (String)"client-id", null, (Validators.Validator)Validators.NO_CHECK);
                    int dupsOKBatchSize = XMLConfigurationUtil.getInteger((Element)e, (String)"dups-ok-batch-size", (int)0x100000, (Validators.Validator)Validators.GT_ZERO);
                    int transactionBatchSize = XMLConfigurationUtil.getInteger((Element)e, (String)"transaction-batch-size", (int)0x100000, (Validators.Validator)Validators.GT_ZERO);
                    int consumerWindowSize = XMLConfigurationUtil.getInteger((Element)e, (String)"consumer-window-size", (int)0x100000, (Validators.Validator)Validators.GE_ZERO);
                    int consumerMaxRate = XMLConfigurationUtil.getInteger((Element)e, (String)"consumer-max-rate", (int)-1, (Validators.Validator)Validators.MINUS_ONE_OR_GT_ZERO);
                    int producerWindowSize = XMLConfigurationUtil.getInteger((Element)e, (String)"producer-window-size", (int)0x100000, (Validators.Validator)Validators.GT_ZERO);
                    int producerMaxRate = XMLConfigurationUtil.getInteger((Element)e, (String)"producer-max-rate", (int)-1, (Validators.Validator)Validators.MINUS_ONE_OR_GT_ZERO);
                    boolean cacheLargeMessagesClient = XMLConfigurationUtil.getBoolean((Element)e, (String)"cache-large-message-client", (boolean)false);
                    int minLargeMessageSize = XMLConfigurationUtil.getInteger((Element)e, (String)"min-large-message-size", (int)102400, (Validators.Validator)Validators.GT_ZERO);
                    boolean blockOnAcknowledge = XMLConfigurationUtil.getBoolean((Element)e, (String)"block-on-acknowledge", (boolean)false);
                    boolean blockOnNonPersistentSend = XMLConfigurationUtil.getBoolean((Element)e, (String)"block-on-non-persistent-send", (boolean)false);
                    boolean blockOnPersistentSend = XMLConfigurationUtil.getBoolean((Element)e, (String)"block-on-persistent-send", (boolean)false);
                    boolean autoGroup = XMLConfigurationUtil.getBoolean((Element)e, (String)"auto-group", (boolean)false);
                    int maxConnections = XMLConfigurationUtil.getInteger((Element)e, (String)"max-connections", (int)8, (Validators.Validator)Validators.GT_ZERO);
                    boolean preAcknowledge = XMLConfigurationUtil.getBoolean((Element)e, (String)"pre-acknowledge", (boolean)false);
                    long retryInterval = XMLConfigurationUtil.getLong((Element)e, (String)"retry-interval", (long)2000L, (Validators.Validator)Validators.GT_ZERO);
                    double retryIntervalMultiplier = XMLConfigurationUtil.getDouble((Element)e, (String)"retry-interval-multiplier", (double)1.0, (Validators.Validator)Validators.GT_ZERO);
                    int reconnectAttempts = XMLConfigurationUtil.getInteger((Element)e, (String)"reconnect-attempts", (int)0, (Validators.Validator)Validators.MINUS_ONE_OR_GE_ZERO);
                    boolean failoverOnServerShutdown = XMLConfigurationUtil.getBoolean((Element)e, (String)"failover-on-server-shutdown", (boolean)false);
                    boolean useGlobalPools = XMLConfigurationUtil.getBoolean((Element)e, (String)"use-global-pools", (boolean)true);
                    int scheduledThreadPoolMaxSize = XMLConfigurationUtil.getInteger((Element)e, (String)"scheduled-thread-pool-max-size", (int)5, (Validators.Validator)Validators.MINUS_ONE_OR_GT_ZERO);
                    int threadPoolMaxSize = XMLConfigurationUtil.getInteger((Element)e, (String)"thread-pool-max-size", (int)-1, (Validators.Validator)Validators.MINUS_ONE_OR_GT_ZERO);
                    String connectionLoadBalancingPolicyClassName = XMLConfigurationUtil.getString((Element)e, (String)"connection-load-balancing-policy-class-name", (String)"org.hornetq.core.client.impl.RoundRobinConnectionLoadBalancingPolicy", (Validators.Validator)Validators.NOT_NULL_OR_EMPTY);
                    long discoveryInitialWaitTimeout = XMLConfigurationUtil.getLong((Element)e, (String)"discovery-initial-wait-timeout", (long)2000L, (Validators.Validator)Validators.GT_ZERO);
                    ArrayList<String> jndiBindings = new ArrayList<String>();
                    ArrayList<Pair<TransportConfiguration, TransportConfiguration>> connectorConfigs = new ArrayList<Pair<TransportConfiguration, TransportConfiguration>>();
                    DiscoveryGroupConfiguration discoveryGroupConfiguration = null;
                    NodeList children = node.getChildNodes();
                    for (int j = 0; j < children.getLength(); ++j) {
                        Node child = children.item(j);
                        if (ENTRIES_NODE_NAME.equals(child.getNodeName())) {
                            NodeList entries = child.getChildNodes();
                            for (int i = 0; i < entries.getLength(); ++i) {
                                Node entry = entries.item(i);
                                if (!ENTRY_NODE_NAME.equals(entry.getNodeName())) continue;
                                String jndiName = entry.getAttributes().getNamedItem("name").getNodeValue();
                                jndiBindings.add(jndiName);
                            }
                            continue;
                        }
                        if (CONNECTOR_REF_ELEMENT.equals(child.getNodeName())) {
                            String connectorName = child.getAttributes().getNamedItem("connector-name").getNodeValue();
                            TransportConfiguration connector = (TransportConfiguration)this.configuration.getConnectorConfigurations().get(connectorName);
                            if (connector == null) {
                                log.warn((Object)("There is no connector with name '" + connectorName + "' deployed."));
                                return;
                            }
                            TransportConfiguration backupConnector = null;
                            Node backupNode = child.getAttributes().getNamedItem("backup-connector-name");
                            if (backupNode != null) {
                                String backupConnectorName = backupNode.getNodeValue();
                                backupConnector = (TransportConfiguration)this.configuration.getConnectorConfigurations().get(backupConnectorName);
                                if (backupConnector == null) {
                                    log.warn((Object)("There is no backup connector with name '" + connectorName + "' deployed."));
                                    return;
                                }
                            }
                            connectorConfigs.add((Pair<TransportConfiguration, TransportConfiguration>)new Pair((Object)connector, backupConnector));
                            continue;
                        }
                        if (!DISCOVERY_GROUP_ELEMENT.equals(child.getNodeName())) continue;
                        String discoveryGroupName = child.getAttributes().getNamedItem("discovery-group-name").getNodeValue();
                        discoveryGroupConfiguration = (DiscoveryGroupConfiguration)this.configuration.getDiscoveryGroupConfigurations().get(discoveryGroupName);
                        if (discoveryGroupConfiguration != null) continue;
                        log.warn((Object)("There is no discovery group with name '" + discoveryGroupName + "' deployed."));
                        return;
                    }
                    String name = node.getAttributes().getNamedItem(this.getKeyAttribute()).getNodeValue();
                    if (discoveryGroupConfiguration != null) {
                        this.jmsServerControl.createConnectionFactory(name, discoveryGroupConfiguration.getGroupAddress(), discoveryGroupConfiguration.getGroupPort(), clientID, discoveryGroupConfiguration.getRefreshTimeout(), clientFailureCheckPeriod, connectionTTL, callTimeout, maxConnections, cacheLargeMessagesClient, minLargeMessageSize, consumerWindowSize, consumerMaxRate, producerWindowSize, producerMaxRate, blockOnAcknowledge, blockOnPersistentSend, blockOnNonPersistentSend, autoGroup, preAcknowledge, connectionLoadBalancingPolicyClassName, transactionBatchSize, dupsOKBatchSize, discoveryInitialWaitTimeout, useGlobalPools, scheduledThreadPoolMaxSize, threadPoolMaxSize, retryInterval, retryIntervalMultiplier, reconnectAttempts, failoverOnServerShutdown, jndiBindings);
                    } else {
                        this.jmsServerControl.createConnectionFactory(name, connectorConfigs, clientID, clientFailureCheckPeriod, connectionTTL, callTimeout, maxConnections, cacheLargeMessagesClient, minLargeMessageSize, consumerWindowSize, consumerMaxRate, producerWindowSize, producerMaxRate, blockOnAcknowledge, blockOnPersistentSend, blockOnNonPersistentSend, autoGroup, preAcknowledge, connectionLoadBalancingPolicyClassName, transactionBatchSize, dupsOKBatchSize, useGlobalPools, scheduledThreadPoolMaxSize, threadPoolMaxSize, retryInterval, retryIntervalMultiplier, reconnectAttempts, failoverOnServerShutdown, jndiBindings);
                    }
                    break block14;
                }
                if (!node.getNodeName().equals(QUEUE_NODE_NAME)) break block15;
                Element e = (Element)node;
                NamedNodeMap atts = node.getAttributes();
                String queueName = atts.getNamedItem(this.getKeyAttribute()).getNodeValue();
                String selectorString = null;
                boolean durable = XMLConfigurationUtil.getBoolean((Element)e, (String)"durable", (boolean)true);
                NodeList children = node.getChildNodes();
                ArrayList<String> jndiNames = new ArrayList<String>();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node child = children.item(i);
                    if (ENTRY_NODE_NAME.equals(children.item(i).getNodeName())) {
                        String jndiName = child.getAttributes().getNamedItem("name").getNodeValue();
                        jndiNames.add(jndiName);
                        continue;
                    }
                    if (!QUEUE_SELECTOR_NODE_NAME.equals(children.item(i).getNodeName())) continue;
                    Node selectorNode = children.item(i);
                    Node attNode = selectorNode.getAttributes().getNamedItem("string");
                    selectorString = attNode.getNodeValue();
                }
                for (String jndiName : jndiNames) {
                    this.jmsServerControl.createQueue(queueName, jndiName, selectorString, durable);
                }
                break block14;
            }
            if (!node.getNodeName().equals(TOPIC_NODE_NAME)) break block14;
            String topicName = node.getAttributes().getNamedItem(this.getKeyAttribute()).getNodeValue();
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!ENTRY_NODE_NAME.equals(children.item(i).getNodeName())) continue;
                String jndiName = child.getAttributes().getNamedItem("name").getNodeValue();
                this.jmsServerControl.createTopic(topicName, jndiName);
            }
        }
    }

    public void undeploy(Node node) throws Exception {
        if (node.getNodeName().equals(CONNECTION_FACTORY_NODE_NAME)) {
            String cfName = node.getAttributes().getNamedItem(this.getKeyAttribute()).getNodeValue();
            this.jmsServerControl.destroyConnectionFactory(cfName);
        } else if (node.getNodeName().equals(QUEUE_NODE_NAME)) {
            String queueName = node.getAttributes().getNamedItem(this.getKeyAttribute()).getNodeValue();
            this.jmsServerControl.undeployDestination(queueName);
        } else if (node.getNodeName().equals(TOPIC_NODE_NAME)) {
            String topicName = node.getAttributes().getNamedItem(this.getKeyAttribute()).getNodeValue();
            this.jmsServerControl.undeployDestination(topicName);
        }
    }

    public String[] getDefaultConfigFileNames() {
        return new String[]{"hornetq-jms.xml"};
    }
}

