/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.server.management.impl;

import javax.jms.JMSException;
import javax.jms.Message;
import org.hornetq.core.client.management.impl.ManagementHelper;
import org.hornetq.jms.client.HornetQMessage;

public class JMSManagementHelper {
    private static org.hornetq.core.message.Message getCoreMessage(Message jmsMessage) {
        if (!(jmsMessage instanceof HornetQMessage)) {
            throw new IllegalArgumentException("Cannot send a non JBoss message as a management message " + jmsMessage.getClass().getName());
        }
        return ((HornetQMessage)jmsMessage).getCoreMessage();
    }

    public static void putAttribute(Message message, String resourceName, String attribute) throws JMSException {
        ManagementHelper.putAttribute((org.hornetq.core.message.Message)JMSManagementHelper.getCoreMessage(message), (String)resourceName, (String)attribute);
    }

    public static void putOperationInvocation(Message message, String resourceName, String operationName) throws JMSException {
        try {
            ManagementHelper.putOperationInvocation((org.hornetq.core.message.Message)JMSManagementHelper.getCoreMessage(message), (String)resourceName, (String)operationName);
        }
        catch (Exception e) {
            throw JMSManagementHelper.convertFromException(e);
        }
    }

    private static JMSException convertFromException(Exception e) {
        JMSException jmse = new JMSException(e.getMessage());
        jmse.initCause((Throwable)e);
        return jmse;
    }

    public static void putOperationInvocation(Message message, String resourceName, String operationName, Object ... parameters) throws JMSException {
        try {
            ManagementHelper.putOperationInvocation((org.hornetq.core.message.Message)JMSManagementHelper.getCoreMessage(message), (String)resourceName, (String)operationName, (Object[])parameters);
        }
        catch (Exception e) {
            throw JMSManagementHelper.convertFromException(e);
        }
    }

    public static boolean isOperationResult(Message message) throws JMSException {
        return ManagementHelper.isOperationResult((org.hornetq.core.message.Message)JMSManagementHelper.getCoreMessage(message));
    }

    public static boolean isAttributesResult(Message message) throws JMSException {
        return ManagementHelper.isAttributesResult((org.hornetq.core.message.Message)JMSManagementHelper.getCoreMessage(message));
    }

    public static boolean hasOperationSucceeded(Message message) throws JMSException {
        return ManagementHelper.hasOperationSucceeded((org.hornetq.core.message.Message)JMSManagementHelper.getCoreMessage(message));
    }

    public static Object[] getResults(Message message) throws Exception {
        return ManagementHelper.getResults((org.hornetq.core.message.Message)JMSManagementHelper.getCoreMessage(message));
    }

    public static Object getResult(Message message) throws Exception {
        return ManagementHelper.getResult((org.hornetq.core.message.Message)JMSManagementHelper.getCoreMessage(message));
    }
}

