/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.server.impl;

import org.hornetq.core.config.Configuration;
import org.hornetq.core.deployers.DeploymentManager;
import org.hornetq.core.deployers.impl.XmlDeployer;
import org.hornetq.core.logging.Logger;
import org.hornetq.jms.server.JMSServerConfigParser;
import org.hornetq.jms.server.JMSServerManager;
import org.hornetq.jms.server.config.ConnectionFactoryConfiguration;
import org.hornetq.jms.server.config.JMSQueueConfiguration;
import org.hornetq.jms.server.config.TopicConfiguration;
import org.hornetq.jms.server.impl.JMSServerConfigParserImpl;
import org.hornetq.utils.XMLUtil;
import org.w3c.dom.Node;

public class JMSServerDeployer
extends XmlDeployer {
    private static final Logger log = Logger.getLogger(JMSServerDeployer.class);
    private final Configuration configuration;
    private final JMSServerConfigParser parser;
    private final JMSServerManager jmsServerManager;
    protected static final String CONNECTOR_REF_ELEMENT = "connector-ref";
    protected static final String DISCOVERY_GROUP_ELEMENT = "discovery-group-ref";
    protected static final String ENTRIES_NODE_NAME = "entries";
    protected static final String ENTRY_NODE_NAME = "entry";
    protected static final String CONNECTORS_NODE_NAME = "connectors";
    protected static final String CONNECTION_FACTORY_NODE_NAME = "connection-factory";
    protected static final String QUEUE_NODE_NAME = "queue";
    protected static final String QUEUE_SELECTOR_NODE_NAME = "selector";
    protected static final String TOPIC_NODE_NAME = "topic";
    protected static final boolean DEFAULT_QUEUE_DURABILITY = true;

    public JMSServerDeployer(JMSServerManager jmsServerManager, DeploymentManager deploymentManager, Configuration config) {
        super(deploymentManager);
        this.jmsServerManager = jmsServerManager;
        this.configuration = config;
        this.parser = new JMSServerConfigParserImpl();
    }

    public String[] getElementTagName() {
        return new String[]{QUEUE_NODE_NAME, TOPIC_NODE_NAME, CONNECTION_FACTORY_NODE_NAME};
    }

    public void validate(Node rootNode) throws Exception {
        XMLUtil.validate((Node)rootNode, (String)"schema/hornetq-jms.xsd");
    }

    public void deploy(Node node) throws Exception {
        this.createAndBindObject(node);
    }

    private void createAndBindObject(Node node) throws Exception {
        if (node.getNodeName().equals(CONNECTION_FACTORY_NODE_NAME)) {
            this.deployConnectionFactory(node);
        } else if (node.getNodeName().equals(QUEUE_NODE_NAME)) {
            this.deployQueue(node);
        } else if (node.getNodeName().equals(TOPIC_NODE_NAME)) {
            this.deployTopic(node);
        }
    }

    public void undeploy(Node node) throws Exception {
        if (node.getNodeName().equals(CONNECTION_FACTORY_NODE_NAME)) {
            String cfName = node.getAttributes().getNamedItem(this.getKeyAttribute()).getNodeValue();
            this.jmsServerManager.destroyConnectionFactory(cfName);
        } else if (node.getNodeName().equals(QUEUE_NODE_NAME)) {
            String queueName = node.getAttributes().getNamedItem(this.getKeyAttribute()).getNodeValue();
            this.jmsServerManager.removeQueueFromJNDI(queueName);
        } else if (node.getNodeName().equals(TOPIC_NODE_NAME)) {
            String topicName = node.getAttributes().getNamedItem(this.getKeyAttribute()).getNodeValue();
            this.jmsServerManager.removeTopicFromJNDI(topicName);
        }
    }

    public String[] getDefaultConfigFileNames() {
        return new String[]{"hornetq-jms.xml"};
    }

    private void deployTopic(Node node) throws Exception {
        TopicConfiguration topicConfig = this.parser.parseTopicConfiguration(node);
        this.jmsServerManager.createTopic(false, topicConfig.getName(), topicConfig.getBindings());
    }

    private void deployQueue(Node node) throws Exception {
        JMSQueueConfiguration queueconfig = this.parser.parseQueueConfiguration(node);
        this.jmsServerManager.createQueue(false, queueconfig.getName(), queueconfig.getSelector(), queueconfig.isDurable(), queueconfig.getBindings());
    }

    private void deployConnectionFactory(Node node) throws Exception {
        ConnectionFactoryConfiguration cfConfig = this.parser.parseConnectionFactoryConfiguration(node);
        this.jmsServerManager.createConnectionFactory(false, cfConfig, cfConfig.getBindings());
    }
}

