/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.server.config.impl;

import java.util.ArrayList;
import java.util.List;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.jms.server.config.ConnectionFactoryConfiguration;
import org.hornetq.jms.server.impl.JMSFactoryType;
import org.hornetq.utils.BufferHelper;

public class ConnectionFactoryConfigurationImpl
implements ConnectionFactoryConfiguration {
    private String name;
    private String[] bindings;
    private List<String> connectorNames;
    private String discoveryGroupName;
    private String clientID = null;
    private boolean ha = false;
    private long clientFailureCheckPeriod = 30000L;
    private long connectionTTL = 60000L;
    private long callTimeout = 30000L;
    private boolean cacheLargeMessagesClient = false;
    private int minLargeMessageSize = 102400;
    private int consumerWindowSize = 0x100000;
    private int consumerMaxRate = -1;
    private int confirmationWindowSize = -1;
    private int producerWindowSize = 65536;
    private int producerMaxRate = -1;
    private boolean blockOnAcknowledge = false;
    private boolean blockOnDurableSend = true;
    private boolean blockOnNonDurableSend = false;
    private boolean autoGroup = false;
    private boolean preAcknowledge = false;
    private String loadBalancingPolicyClassName = HornetQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME;
    private int transactionBatchSize = 0x100000;
    private int dupsOKBatchSize = 0x100000;
    private long initialWaitTimeout = 10000L;
    private boolean useGlobalPools = true;
    private int scheduledThreadPoolMaxSize = 5;
    private int threadPoolMaxSize = -1;
    private long retryInterval = 2000L;
    private double retryIntervalMultiplier = 1.0;
    private long maxRetryInterval = 2000L;
    private int reconnectAttempts = 0;
    private boolean failoverOnInitialConnection = false;
    private String groupID = null;
    private JMSFactoryType factoryType = JMSFactoryType.CF;

    public ConnectionFactoryConfigurationImpl() {
    }

    public ConnectionFactoryConfigurationImpl(String name, boolean ha, List<String> connectorNames, String ... bindings) {
        this(name, ha, bindings);
        this.connectorNames = connectorNames;
    }

    public ConnectionFactoryConfigurationImpl(String name, boolean ha, String ... bindings) {
        this.name = name;
        this.ha = ha;
        this.bindings = new String[bindings.length];
        System.arraycopy(bindings, 0, this.bindings, 0, bindings.length);
    }

    @Override
    public String[] getBindings() {
        return this.bindings;
    }

    @Override
    public void setBindings(String[] bindings) {
        this.bindings = bindings;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDiscoveryGroupName() {
        return this.discoveryGroupName;
    }

    @Override
    public void setDiscoveryGroupName(String discoveryGroupName) {
        this.discoveryGroupName = discoveryGroupName;
    }

    @Override
    public List<String> getConnectorNames() {
        return this.connectorNames;
    }

    @Override
    public void setConnectorNames(List<String> connectorNames) {
        this.connectorNames = connectorNames;
    }

    @Override
    public boolean isHA() {
        return this.ha;
    }

    @Override
    public void setHA(boolean ha) {
        this.ha = ha;
    }

    @Override
    public String getClientID() {
        return this.clientID;
    }

    @Override
    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    @Override
    public long getClientFailureCheckPeriod() {
        return this.clientFailureCheckPeriod;
    }

    @Override
    public void setClientFailureCheckPeriod(long clientFailureCheckPeriod) {
        this.clientFailureCheckPeriod = clientFailureCheckPeriod;
    }

    @Override
    public long getConnectionTTL() {
        return this.connectionTTL;
    }

    @Override
    public void setConnectionTTL(long connectionTTL) {
        this.connectionTTL = connectionTTL;
    }

    @Override
    public long getCallTimeout() {
        return this.callTimeout;
    }

    @Override
    public void setCallTimeout(long callTimeout) {
        this.callTimeout = callTimeout;
    }

    @Override
    public boolean isCacheLargeMessagesClient() {
        return this.cacheLargeMessagesClient;
    }

    @Override
    public void setCacheLargeMessagesClient(boolean cacheLargeMessagesClient) {
        this.cacheLargeMessagesClient = cacheLargeMessagesClient;
    }

    @Override
    public int getMinLargeMessageSize() {
        return this.minLargeMessageSize;
    }

    @Override
    public void setMinLargeMessageSize(int minLargeMessageSize) {
        this.minLargeMessageSize = minLargeMessageSize;
    }

    @Override
    public int getConsumerWindowSize() {
        return this.consumerWindowSize;
    }

    @Override
    public void setConsumerWindowSize(int consumerWindowSize) {
        this.consumerWindowSize = consumerWindowSize;
    }

    @Override
    public int getConsumerMaxRate() {
        return this.consumerMaxRate;
    }

    @Override
    public void setConsumerMaxRate(int consumerMaxRate) {
        this.consumerMaxRate = consumerMaxRate;
    }

    @Override
    public int getConfirmationWindowSize() {
        return this.confirmationWindowSize;
    }

    @Override
    public void setConfirmationWindowSize(int confirmationWindowSize) {
        this.confirmationWindowSize = confirmationWindowSize;
    }

    @Override
    public int getProducerMaxRate() {
        return this.producerMaxRate;
    }

    @Override
    public void setProducerMaxRate(int producerMaxRate) {
        this.producerMaxRate = producerMaxRate;
    }

    @Override
    public int getProducerWindowSize() {
        return this.producerWindowSize;
    }

    @Override
    public void setProducerWindowSize(int producerWindowSize) {
        this.producerWindowSize = producerWindowSize;
    }

    @Override
    public boolean isBlockOnAcknowledge() {
        return this.blockOnAcknowledge;
    }

    @Override
    public void setBlockOnAcknowledge(boolean blockOnAcknowledge) {
        this.blockOnAcknowledge = blockOnAcknowledge;
    }

    @Override
    public boolean isBlockOnDurableSend() {
        return this.blockOnDurableSend;
    }

    @Override
    public void setBlockOnDurableSend(boolean blockOnDurableSend) {
        this.blockOnDurableSend = blockOnDurableSend;
    }

    @Override
    public boolean isBlockOnNonDurableSend() {
        return this.blockOnNonDurableSend;
    }

    @Override
    public void setBlockOnNonDurableSend(boolean blockOnNonDurableSend) {
        this.blockOnNonDurableSend = blockOnNonDurableSend;
    }

    @Override
    public boolean isAutoGroup() {
        return this.autoGroup;
    }

    @Override
    public void setAutoGroup(boolean autoGroup) {
        this.autoGroup = autoGroup;
    }

    @Override
    public boolean isPreAcknowledge() {
        return this.preAcknowledge;
    }

    @Override
    public void setPreAcknowledge(boolean preAcknowledge) {
        this.preAcknowledge = preAcknowledge;
    }

    @Override
    public String getLoadBalancingPolicyClassName() {
        return this.loadBalancingPolicyClassName;
    }

    @Override
    public void setLoadBalancingPolicyClassName(String loadBalancingPolicyClassName) {
        this.loadBalancingPolicyClassName = loadBalancingPolicyClassName;
    }

    @Override
    public int getTransactionBatchSize() {
        return this.transactionBatchSize;
    }

    @Override
    public void setTransactionBatchSize(int transactionBatchSize) {
        this.transactionBatchSize = transactionBatchSize;
    }

    @Override
    public int getDupsOKBatchSize() {
        return this.dupsOKBatchSize;
    }

    @Override
    public void setDupsOKBatchSize(int dupsOKBatchSize) {
        this.dupsOKBatchSize = dupsOKBatchSize;
    }

    public long getInitialWaitTimeout() {
        return this.initialWaitTimeout;
    }

    public void setInitialWaitTimeout(long initialWaitTimeout) {
        this.initialWaitTimeout = initialWaitTimeout;
    }

    @Override
    public boolean isUseGlobalPools() {
        return this.useGlobalPools;
    }

    @Override
    public void setUseGlobalPools(boolean useGlobalPools) {
        this.useGlobalPools = useGlobalPools;
    }

    @Override
    public int getScheduledThreadPoolMaxSize() {
        return this.scheduledThreadPoolMaxSize;
    }

    @Override
    public void setScheduledThreadPoolMaxSize(int scheduledThreadPoolMaxSize) {
        this.scheduledThreadPoolMaxSize = scheduledThreadPoolMaxSize;
    }

    @Override
    public int getThreadPoolMaxSize() {
        return this.threadPoolMaxSize;
    }

    @Override
    public void setThreadPoolMaxSize(int threadPoolMaxSize) {
        this.threadPoolMaxSize = threadPoolMaxSize;
    }

    @Override
    public long getRetryInterval() {
        return this.retryInterval;
    }

    @Override
    public void setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
    }

    @Override
    public double getRetryIntervalMultiplier() {
        return this.retryIntervalMultiplier;
    }

    @Override
    public void setRetryIntervalMultiplier(double retryIntervalMultiplier) {
        this.retryIntervalMultiplier = retryIntervalMultiplier;
    }

    @Override
    public long getMaxRetryInterval() {
        return this.maxRetryInterval;
    }

    @Override
    public void setMaxRetryInterval(long maxRetryInterval) {
        this.maxRetryInterval = maxRetryInterval;
    }

    @Override
    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    @Override
    public void setReconnectAttempts(int reconnectAttempts) {
        this.reconnectAttempts = reconnectAttempts;
    }

    @Override
    public boolean isFailoverOnInitialConnection() {
        return this.failoverOnInitialConnection;
    }

    @Override
    public void setFailoverOnInitialConnection(boolean failover) {
        this.failoverOnInitialConnection = failover;
    }

    @Override
    public String getGroupID() {
        return this.groupID;
    }

    @Override
    public void setGroupID(String groupID) {
        this.groupID = groupID;
    }

    public void decode(HornetQBuffer buffer) {
        this.name = buffer.readSimpleString().toString();
        this.discoveryGroupName = BufferHelper.readNullableSimpleStringAsString((HornetQBuffer)buffer);
        int nConnectors = buffer.readInt();
        if (nConnectors > 0) {
            this.connectorNames = new ArrayList<String>(nConnectors);
            for (int i = 0; i < nConnectors; ++i) {
                SimpleString str = buffer.readSimpleString();
                this.connectorNames.add(str.toString());
            }
        }
        this.clientID = BufferHelper.readNullableSimpleStringAsString((HornetQBuffer)buffer);
        this.clientFailureCheckPeriod = buffer.readLong();
        this.connectionTTL = buffer.readLong();
        this.callTimeout = buffer.readLong();
        this.cacheLargeMessagesClient = buffer.readBoolean();
        this.minLargeMessageSize = buffer.readInt();
        this.consumerWindowSize = buffer.readInt();
        this.consumerMaxRate = buffer.readInt();
        this.confirmationWindowSize = buffer.readInt();
        this.producerWindowSize = buffer.readInt();
        this.producerMaxRate = buffer.readInt();
        this.blockOnAcknowledge = buffer.readBoolean();
        this.blockOnDurableSend = buffer.readBoolean();
        this.blockOnNonDurableSend = buffer.readBoolean();
        this.autoGroup = buffer.readBoolean();
        this.preAcknowledge = buffer.readBoolean();
        this.loadBalancingPolicyClassName = buffer.readSimpleString().toString();
        this.transactionBatchSize = buffer.readInt();
        this.dupsOKBatchSize = buffer.readInt();
        this.initialWaitTimeout = buffer.readLong();
        this.useGlobalPools = buffer.readBoolean();
        this.scheduledThreadPoolMaxSize = buffer.readInt();
        this.threadPoolMaxSize = buffer.readInt();
        this.retryInterval = buffer.readLong();
        this.retryIntervalMultiplier = buffer.readDouble();
        this.maxRetryInterval = buffer.readLong();
        this.reconnectAttempts = buffer.readInt();
        this.failoverOnInitialConnection = buffer.readBoolean();
        this.groupID = BufferHelper.readNullableSimpleStringAsString((HornetQBuffer)buffer);
        this.factoryType = JMSFactoryType.valueOf(buffer.readInt());
    }

    public void encode(HornetQBuffer buffer) {
        BufferHelper.writeAsSimpleString((HornetQBuffer)buffer, (String)this.name);
        BufferHelper.writeAsNullableSimpleString((HornetQBuffer)buffer, (String)this.discoveryGroupName);
        if (this.connectorNames == null) {
            buffer.writeInt(0);
        } else {
            buffer.writeInt(this.connectorNames.size());
            for (String tc : this.connectorNames) {
                BufferHelper.writeAsSimpleString((HornetQBuffer)buffer, (String)tc);
            }
        }
        BufferHelper.writeAsNullableSimpleString((HornetQBuffer)buffer, (String)this.clientID);
        buffer.writeLong(this.clientFailureCheckPeriod);
        buffer.writeLong(this.connectionTTL);
        buffer.writeLong(this.callTimeout);
        buffer.writeBoolean(this.cacheLargeMessagesClient);
        buffer.writeInt(this.minLargeMessageSize);
        buffer.writeInt(this.consumerWindowSize);
        buffer.writeInt(this.consumerMaxRate);
        buffer.writeInt(this.confirmationWindowSize);
        buffer.writeInt(this.producerWindowSize);
        buffer.writeInt(this.producerMaxRate);
        buffer.writeBoolean(this.blockOnAcknowledge);
        buffer.writeBoolean(this.blockOnDurableSend);
        buffer.writeBoolean(this.blockOnNonDurableSend);
        buffer.writeBoolean(this.autoGroup);
        buffer.writeBoolean(this.preAcknowledge);
        BufferHelper.writeAsSimpleString((HornetQBuffer)buffer, (String)this.loadBalancingPolicyClassName);
        buffer.writeInt(this.transactionBatchSize);
        buffer.writeInt(this.dupsOKBatchSize);
        buffer.writeLong(this.initialWaitTimeout);
        buffer.writeBoolean(this.useGlobalPools);
        buffer.writeInt(this.scheduledThreadPoolMaxSize);
        buffer.writeInt(this.threadPoolMaxSize);
        buffer.writeLong(this.retryInterval);
        buffer.writeDouble(this.retryIntervalMultiplier);
        buffer.writeLong(this.maxRetryInterval);
        buffer.writeInt(this.reconnectAttempts);
        buffer.writeBoolean(this.failoverOnInitialConnection);
        BufferHelper.writeAsNullableSimpleString((HornetQBuffer)buffer, (String)this.groupID);
        buffer.writeInt(this.factoryType.intValue());
    }

    public int getEncodeSize() {
        int size = BufferHelper.sizeOfSimpleString((String)this.name) + BufferHelper.sizeOfNullableSimpleString((String)this.discoveryGroupName);
        size += 4;
        if (this.connectorNames != null) {
            for (String tc : this.connectorNames) {
                size += BufferHelper.sizeOfSimpleString((String)tc);
            }
        }
        return size += BufferHelper.sizeOfNullableSimpleString((String)this.clientID) + 8 + 8 + 8 + 1 + 4 + 4 + 4 + 4 + 4 + 4 + 1 + 1 + 1 + 1 + 1 + BufferHelper.sizeOfSimpleString((String)this.loadBalancingPolicyClassName) + 4 + 4 + 8 + 1 + 4 + 4 + 8 + 8 + 8 + 4 + 1 + BufferHelper.sizeOfNullableSimpleString((String)this.groupID) + 4;
    }

    @Override
    public void setFactoryType(JMSFactoryType factoryType) {
        this.factoryType = factoryType;
    }

    @Override
    public JMSFactoryType getFactoryType() {
        return this.factoryType;
    }
}

