/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.server.recovery;

import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.api.core.client.SessionFailureListener;
import org.hornetq.core.logging.Logger;

public class HornetQXAResourceWrapper
implements XAResource,
SessionFailureListener {
    private static final Logger log = Logger.getLogger(HornetQXAResourceWrapper.class);
    private static final Object lock = new Object();
    private final String connectorFactoryClassName;
    private final Map<String, Object> connectorConfig;
    private final String username;
    private final String password;
    private ServerLocator serverLocator;
    private ClientSessionFactory csf;
    private XAResource delegate;

    public HornetQXAResourceWrapper(String connectorFactoryClassName, Map<String, Object> connectorConfig, String username, String password) {
        this.connectorFactoryClassName = connectorFactoryClassName;
        this.connectorConfig = connectorConfig;
        this.username = username;
        this.password = password;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        log.debug((Object)("Recover " + this.connectorFactoryClassName));
        XAResource xaResource = this.getDelegate();
        try {
            return xaResource.recover(flag);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        log.debug((Object)("Commit " + this.connectorFactoryClassName + " xid " + " onePhase=" + onePhase));
        XAResource xaResource = this.getDelegate();
        try {
            xaResource.commit(xid, onePhase);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        log.debug((Object)("Rollback " + this.connectorFactoryClassName + " xid "));
        XAResource xaResource = this.getDelegate();
        try {
            xaResource.rollback(xid);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        log.debug((Object)("Forget " + this.connectorFactoryClassName + " xid "));
        XAResource xaResource = this.getDelegate();
        try {
            xaResource.forget(xid);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public boolean isSameRM(XAResource xaRes) throws XAException {
        if (xaRes instanceof HornetQXAResourceWrapper) {
            xaRes = ((HornetQXAResourceWrapper)xaRes).getDelegate();
        }
        XAResource xaResource = this.getDelegate();
        try {
            return xaResource.isSameRM(xaRes);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        XAResource xaResource = this.getDelegate();
        try {
            return xaResource.prepare(xid);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        XAResource xaResource = this.getDelegate();
        try {
            xaResource.start(xid, flags);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        XAResource xaResource = this.getDelegate();
        try {
            xaResource.end(xid, flags);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        XAResource xaResource = this.getDelegate();
        try {
            return xaResource.getTransactionTimeout();
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        XAResource xaResource = this.getDelegate();
        try {
            return xaResource.setTransactionTimeout(seconds);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    public void connectionFailed(HornetQException me, boolean failedOver) {
        log.warn((Object)("Notified of connection failure in recovery connectionFactory for provider " + this.connectorFactoryClassName), (Throwable)me);
        this.close();
    }

    public void beforeReconnect(HornetQException me) {
    }

    public XAResource getDelegate() throws XAException {
        XAResource result = null;
        Exception error = null;
        try {
            result = this.connect();
        }
        catch (Exception e) {
            log.error((Object)"********************************Failed to connect to server", (Throwable)e);
            error = e;
        }
        if (result == null) {
            XAException xae = new XAException("Error trying to connect to provider " + this.connectorFactoryClassName);
            xae.errorCode = -3;
            if (error != null) {
                xae.initCause(error);
            }
            log.debug((Object)"Cannot get connectionFactory XAResource", (Throwable)xae);
            throw xae;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XAResource connect() throws Exception {
        Object object = lock;
        synchronized (object) {
            if (this.delegate != null) {
                return this.delegate;
            }
        }
        TransportConfiguration config = new TransportConfiguration(this.connectorFactoryClassName, this.connectorConfig);
        this.serverLocator = HornetQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{config});
        this.csf = this.serverLocator.createSessionFactory();
        ClientSession cs = null;
        cs = this.username == null ? this.csf.createSession(true, false, false) : this.csf.createSession(this.username, this.password, true, false, false, false, 1);
        cs.addFailureListener((SessionFailureListener)this);
        Object object2 = lock;
        synchronized (object2) {
            this.delegate = cs;
        }
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            ServerLocator oldServerLocator = null;
            ClientSessionFactory oldCSF = null;
            Object object = lock;
            synchronized (object) {
                oldCSF = this.csf;
                this.csf = null;
                this.delegate = null;
                oldServerLocator = this.serverLocator;
                this.serverLocator = null;
            }
            if (oldCSF != null) {
                oldCSF.close();
                oldServerLocator.close();
            }
        }
        catch (Exception ignored) {
            log.trace((Object)"Ignored error during close", (Throwable)ignored);
        }
    }

    protected XAException check(XAException e) throws XAException {
        if (e.errorCode == 4) {
            log.debug((Object)("Fatal error in provider " + this.connectorFactoryClassName), (Throwable)e);
            this.close();
        }
        throw new XAException(-7);
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

