/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.server.recovery;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.xa.XAResource;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.logging.Logger;
import org.hornetq.jms.server.recovery.HornetQXAResourceWrapper;
import org.hornetq.jms.server.recovery.RecoveryDiscovery;
import org.hornetq.jms.server.recovery.XARecoveryConfig;
import org.jboss.tm.XAResourceRecovery;

public class HornetQRecoveryRegistry
implements XAResourceRecovery {
    private static final Logger log = Logger.getLogger(HornetQRecoveryRegistry.class);
    private static final HornetQRecoveryRegistry theInstance = new HornetQRecoveryRegistry();
    private ConcurrentHashMap<XARecoveryConfig, RecoveryDiscovery> configSet = new ConcurrentHashMap();
    private ConcurrentHashMap<String, HornetQXAResourceWrapper> recoveries = new ConcurrentHashMap();
    private Set<RecoveryDiscovery> failedDiscoverySet = new HashSet<RecoveryDiscovery>();

    private HornetQRecoveryRegistry() {
    }

    public XAResource[] getXAResources() {
        try {
            this.checkFailures();
            XAResource[] resourceArray = new HornetQXAResourceWrapper[this.recoveries.size()];
            resourceArray = this.recoveries.values().toArray(resourceArray);
            if (log.isDebugEnabled()) {
                log.debug((Object)"\n=======================================================================================");
                log.debug((Object)"Returning the following list on getXAREsources:");
                for (Map.Entry<String, HornetQXAResourceWrapper> entry : this.recoveries.entrySet()) {
                    log.debug((Object)("server-id=" + entry.getKey() + ", value=" + entry.getValue()));
                }
                log.debug((Object)"=======================================================================================\n");
            }
            return resourceArray;
        }
        catch (Throwable e) {
            log.warn((Object)e.getMessage(), e);
            return new XAResource[0];
        }
    }

    public static HornetQRecoveryRegistry getInstance() {
        return theInstance;
    }

    public void register(XARecoveryConfig resourceConfig) {
        RecoveryDiscovery newInstance = new RecoveryDiscovery(resourceConfig);
        RecoveryDiscovery discoveryRecord = this.configSet.putIfAbsent(resourceConfig, newInstance);
        if (discoveryRecord == null) {
            discoveryRecord = newInstance;
            discoveryRecord.start();
        }
        discoveryRecord.incrementUsage();
    }

    public void unRegister(XARecoveryConfig resourceConfig) {
        RecoveryDiscovery discoveryRecord = this.configSet.get(resourceConfig);
        if (discoveryRecord != null && discoveryRecord.decrementUsage() == 0 && (discoveryRecord = this.configSet.remove(resourceConfig)) != null) {
            discoveryRecord.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failedDiscovery(RecoveryDiscovery failedDiscovery) {
        log.debug((Object)("RecoveryDiscovery being set to restart:" + failedDiscovery));
        Set<RecoveryDiscovery> set = this.failedDiscoverySet;
        synchronized (set) {
            this.failedDiscoverySet.add(failedDiscovery);
        }
    }

    public void nodeUp(String nodeID, Pair<TransportConfiguration, TransportConfiguration> networkConfiguration, String username, String password) {
        if (this.recoveries.get(nodeID) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(nodeID + " being registered towards " + networkConfiguration));
            }
            XARecoveryConfig config = new XARecoveryConfig(true, this.extractTransportConfiguration(networkConfiguration), username, password);
            HornetQXAResourceWrapper wrapper = new HornetQXAResourceWrapper(config);
            this.recoveries.put(nodeID, wrapper);
        }
    }

    public void nodeDown(String nodeID) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFailures() {
        final HashSet<RecoveryDiscovery> failures = new HashSet<RecoveryDiscovery>();
        Set<RecoveryDiscovery> set = this.failedDiscoverySet;
        synchronized (set) {
            failures.addAll(this.failedDiscoverySet);
            this.failedDiscoverySet.clear();
        }
        if (failures.size() > 0) {
            Thread t = new Thread("HornetQ Recovery Discovery Reinitialization"){

                @Override
                public void run() {
                    for (RecoveryDiscovery discovery : failures) {
                        try {
                            log.debug((Object)("Retrying discovery " + discovery));
                            discovery.start();
                        }
                        catch (Throwable e) {
                            log.warn((Object)e.getMessage(), e);
                        }
                    }
                }
            };
            t.start();
        }
    }

    private TransportConfiguration[] extractTransportConfiguration(Pair<TransportConfiguration, TransportConfiguration> networkConfiguration) {
        if (networkConfiguration.getB() != null) {
            return new TransportConfiguration[]{(TransportConfiguration)networkConfiguration.getA(), (TransportConfiguration)networkConfiguration.getB()};
        }
        return new TransportConfiguration[]{(TransportConfiguration)networkConfiguration.getA()};
    }
}

