/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.integration.logging;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public abstract class BaseLoggerHandler
extends Handler {
    public static final int SEVERE = 1000;
    public static final int WARNING = 900;
    public static final int INFO = 800;
    public static final int CONFIG = 700;
    public static final int FINE = 500;
    public static final int FINER = 400;
    public static final int FINEST = 300;

    public void publish(LogRecord record) {
        String loggerName = record.getLoggerName();
        Level level = record.getLevel();
        String message = record.getMessage();
        Throwable throwable = record.getThrown();
        this.publish(loggerName, level, message, throwable);
    }

    abstract void publish(String var1, Level var2, String var3, Throwable var4);

    public void flush() {
    }

    public void close() throws SecurityException {
    }
}

