/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.integration.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class HornetQLoggerFormatter
extends Formatter {
    private static String LINE_SEPARATOR = System.getProperty("line.separator");

    public String format(LogRecord record) {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss,SSS");
        StringBuffer sb = new StringBuffer();
        date.setTime(record.getMillis());
        sb.append("[").append(Thread.currentThread().getName()).append("] ");
        sb.append(dateFormat.format(date)).append(" ");
        sb.append(record.getLevel()).append(" [");
        sb.append(record.getLoggerName()).append("]").append("  ");
        sb.append(record.getMessage());
        sb.append(LINE_SEPARATOR);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return sb.toString();
    }
}

