/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.integration.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class HornetQLoggerFormatter
extends Formatter {
    private static String LINE_SEPARATOR = System.getProperty("line.separator");
    private static String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    private String stripPackage(String clazzName) {
        return clazzName.substring(clazzName.lastIndexOf(".") + 1);
    }

    @Override
    public String format(LogRecord record) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTimeInMillis(record.getMillis());
        StringBuffer sb = new StringBuffer();
        sb.append("* [").append(Thread.currentThread().getName()).append("] ");
        sb.append(calendar.get(5) + "-" + MONTHS[calendar.get(2)] + " " + calendar.get(11) + ":" + calendar.get(12) + ":" + calendar.get(13) + "," + calendar.get(14) + " ");
        sb.append(record.getLevel()).append(" [");
        sb.append(this.stripPackage(record.getLoggerName())).append("]").append("  ");
        sb.append(record.getMessage());
        sb.append(LINE_SEPARATOR);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                pw.println(record.getThrown());
                StackTraceElement[] trace = record.getThrown().getStackTrace();
                for (int i = 0; i < trace.length; ++i) {
                    pw.println("\tat " + trace[i]);
                }
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        sb.append(LINE_SEPARATOR);
        return sb.toString();
    }
}

