/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.maven;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.ClassWorld;
import org.hornetq.server.HornetQBootstrap;
import org.hornetq.server.SpawnedHornetQBootstrap;
import org.hornetq.server.SpawnedVMSupport;

public class HornetQStartPlugin
extends AbstractMojo {
    private PluginDescriptor descriptor;
    private Boolean waitOnStart;
    private String hornetqConfigurationDir;
    private Boolean useJndi;
    private String nodeId;
    private String jndiHost;
    private int jndiPort;
    private int jndiRmiPort;
    private Boolean fork;
    private Boolean debug;
    private Properties systemProperties;
    private String serverStartString;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.systemProperties != null && !this.systemProperties.isEmpty()) {
            System.getProperties().putAll((Map<?, ?>)this.systemProperties);
        }
        if (this.fork.booleanValue()) {
            try {
                PluginDescriptor pd = (PluginDescriptor)this.getPluginContext().get("pluginDescriptor");
                final Process p = SpawnedVMSupport.spawnVM(pd.getArtifacts(), "HornetQServer_" + (this.nodeId != null ? this.nodeId : ""), SpawnedHornetQBootstrap.class.getName(), this.systemProperties, true, this.serverStartString, "FAILED::", ".", this.hornetqConfigurationDir, this.debug, this.useJndi.toString(), this.jndiHost, "" + this.jndiPort, "" + this.jndiRmiPort, this.hornetqConfigurationDir, "" + this.waitOnStart, this.nodeId);
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        p.destroy();
                    }
                });
                if (!this.waitOnStart.booleanValue()) return;
                p.waitFor();
                return;
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new MojoExecutionException(e.getMessage());
            }
        }
        HornetQBootstrap bootstrap = new HornetQBootstrap(this.useJndi, this.jndiHost, this.jndiPort, this.jndiRmiPort, this.hornetqConfigurationDir, this.waitOnStart, this.nodeId);
        if (this.hornetqConfigurationDir != null) {
            this.extendPluginClasspath(this.hornetqConfigurationDir);
        }
        try {
            bootstrap.execute();
            return;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    public void extendPluginClasspath(String element) throws MojoExecutionException {
        ClassRealm realm;
        ClassWorld world = new ClassWorld();
        try {
            realm = world.newRealm("maven.plugin." + ((Object)((Object)this)).getClass().getSimpleName() + (this.nodeId == null ? "" : this.nodeId), Thread.currentThread().getContextClassLoader());
            File elementFile = new File(element);
            this.getLog().debug((CharSequence)("Adding element to plugin classpath" + elementFile.getPath()));
            realm.addConstituent(elementFile.toURI().toURL());
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.toString(), ex);
        }
        System.out.println(realm.getConstituents());
        Thread.currentThread().setContextClassLoader(realm.getClassLoader());
    }
}

