/*
 * Decompiled with CFR 0.152.
 */
package org.proton.plug.context;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.engine.Transport;
import org.proton.plug.AMQPConnectionCallback;
import org.proton.plug.AMQPConnectionContext;
import org.proton.plug.SASLResult;
import org.proton.plug.context.AbstractProtonSessionContext;
import org.proton.plug.context.ProtonDeliveryHandler;
import org.proton.plug.context.ProtonInitializable;
import org.proton.plug.exceptions.HornetQAMQPException;
import org.proton.plug.handler.ProtonHandler;
import org.proton.plug.handler.impl.DefaultEventHandler;

public abstract class AbstractConnectionContext
extends ProtonInitializable
implements AMQPConnectionContext {
    protected ProtonHandler handler = ProtonHandler.Factory.create();
    protected AMQPConnectionCallback connectionCallback;
    private final Map<Session, AbstractProtonSessionContext> sessions = new ConcurrentHashMap<Session, AbstractProtonSessionContext>();

    public AbstractConnectionContext(AMQPConnectionCallback connectionCallback) {
        this.connectionCallback = connectionCallback;
        connectionCallback.setConnection(this);
        this.handler.addEventHandler(new LocalListener());
    }

    @Override
    public SASLResult getSASLResult() {
        return this.handler.getSASLResult();
    }

    @Override
    public void inputBuffer(ByteBuf buffer) {
        this.handler.inputBuffer(buffer);
    }

    public void destroy() {
        this.connectionCallback.close();
    }

    @Override
    public boolean isSyncOnFlush() {
        return false;
    }

    @Override
    public Object getLock() {
        return this.handler.getLock();
    }

    @Override
    public int capacity() {
        return this.handler.capacity();
    }

    @Override
    public void outputDone(int bytes) {
        this.handler.outputDone(bytes);
    }

    @Override
    public void flush() {
        this.handler.flush();
    }

    @Override
    public void close() {
        this.handler.close();
    }

    protected AbstractProtonSessionContext getSessionExtension(Session realSession) throws HornetQAMQPException {
        AbstractProtonSessionContext sessionExtension = this.sessions.get(realSession);
        if (sessionExtension == null) {
            sessionExtension = this.newSessionExtension(realSession);
            realSession.setContext((Object)sessionExtension);
            this.sessions.put(realSession, sessionExtension);
        }
        return sessionExtension;
    }

    protected abstract void remoteLinkOpened(Link var1) throws Exception;

    protected abstract AbstractProtonSessionContext newSessionExtension(Session var1) throws HornetQAMQPException;

    @Override
    public boolean checkDataReceived() {
        return this.handler.checkDataReceived();
    }

    @Override
    public long getCreationTime() {
        return this.handler.getCreationTime();
    }

    protected void flushBytes() {
        ByteBuf bytes;
        while ((bytes = this.handler.outputBuffer()) != null) {
            this.connectionCallback.onTransport(bytes, this);
        }
    }

    class LocalListener
    extends DefaultEventHandler {
        LocalListener() {
        }

        @Override
        public void onSASLInit(ProtonHandler handler, Connection connection) {
            handler.createServerSASL(AbstractConnectionContext.this.connectionCallback.getSASLMechnisms());
        }

        @Override
        public void onTransport(Transport transport) {
            AbstractConnectionContext.this.flushBytes();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoteOpen(Connection connection) throws Exception {
            Object object = AbstractConnectionContext.this.getLock();
            synchronized (object) {
                connection.setContext((Object)AbstractConnectionContext.this);
                connection.open();
            }
            AbstractConnectionContext.this.initialise();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoteClose(Connection connection) {
            Object object = AbstractConnectionContext.this.getLock();
            synchronized (object) {
                connection.close();
                for (AbstractProtonSessionContext protonSession : AbstractConnectionContext.this.sessions.values()) {
                    protonSession.close();
                }
                AbstractConnectionContext.this.sessions.clear();
            }
            this.onTransport(AbstractConnectionContext.this.handler.getTransport());
            AbstractConnectionContext.this.destroy();
        }

        @Override
        public void onLocalOpen(Session session) throws Exception {
            AbstractConnectionContext.this.getSessionExtension(session);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoteOpen(Session session) throws Exception {
            AbstractConnectionContext.this.getSessionExtension(session).initialise();
            Object object = AbstractConnectionContext.this.getLock();
            synchronized (object) {
                session.open();
            }
        }

        @Override
        public void onLocalClose(Session session) throws Exception {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoteClose(Session session) throws Exception {
            Object object = AbstractConnectionContext.this.getLock();
            synchronized (object) {
                session.close();
            }
            AbstractProtonSessionContext sessionContext = (AbstractProtonSessionContext)session.getContext();
            if (sessionContext != null) {
                sessionContext.close();
                AbstractConnectionContext.this.sessions.remove(session);
                session.setContext(null);
            }
        }

        @Override
        public void onRemoteOpen(Link link) throws Exception {
            AbstractConnectionContext.this.remoteLinkOpened(link);
        }

        @Override
        public void onFlow(Link link) throws Exception {
            ((ProtonDeliveryHandler)link.getContext()).onFlow(link.getCredit());
        }

        @Override
        public void onRemoteClose(Link link) throws Exception {
            link.close();
            ((ProtonDeliveryHandler)link.getContext()).close();
        }

        @Override
        public void onRemoteDetach(Link link) throws Exception {
            link.detach();
        }

        @Override
        public void onDelivery(Delivery delivery) throws Exception {
            ProtonDeliveryHandler handler = (ProtonDeliveryHandler)delivery.getLink().getContext();
            if (handler != null) {
                handler.onMessage(delivery);
            } else {
                System.err.println("Handler is null, can't delivery " + delivery);
            }
        }
    }
}

