/*
 * Decompiled with CFR 0.152.
 */
package org.proton.plug.context;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.transaction.Declare;
import org.apache.qpid.proton.amqp.transaction.Declared;
import org.apache.qpid.proton.amqp.transaction.Discharge;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.message.impl.MessageImpl;
import org.proton.plug.AMQPSessionCallback;
import org.proton.plug.context.ProtonDeliveryHandler;
import org.proton.plug.exceptions.HornetQAMQPException;
import org.proton.plug.logger.HornetQAMQPProtocolMessageBundle;
import org.proton.plug.util.DeliveryUtil;

public class ProtonTransactionHandler
implements ProtonDeliveryHandler {
    final AMQPSessionCallback sessionSPI;

    public ProtonTransactionHandler(AMQPSessionCallback sessionSPI) {
        this.sessionSPI = sessionSPI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(Delivery delivery) throws HornetQAMQPException {
        block13: {
            ByteBuf buffer = PooledByteBufAllocator.DEFAULT.heapBuffer(1024);
            try {
                Receiver receiver = (Receiver)delivery.getLink();
                if (!delivery.isReadable()) {
                    return;
                }
                DeliveryUtil.readDelivery(receiver, buffer);
                receiver.advance();
                MessageImpl msg = DeliveryUtil.decodeMessageImpl(buffer);
                Object action = ((AmqpValue)msg.getBody()).getValue();
                if (action instanceof Declare) {
                    Binary txID = this.sessionSPI.getCurrentTXID();
                    Declared declared = new Declared();
                    declared.setTxnId(txID);
                    delivery.disposition((DeliveryState)declared);
                    delivery.settle();
                    break block13;
                }
                if (!(action instanceof Discharge)) break block13;
                Discharge discharge = (Discharge)action;
                if (discharge.getFail().booleanValue()) {
                    try {
                        this.sessionSPI.rollbackCurrentTX();
                    }
                    catch (Exception e) {
                        throw HornetQAMQPProtocolMessageBundle.BUNDLE.errorRollingbackCoordinator(e.getMessage());
                    }
                }
                try {
                    this.sessionSPI.commitCurrentTX();
                }
                catch (Exception e) {
                    throw HornetQAMQPProtocolMessageBundle.BUNDLE.errorCommittingCoordinator(e.getMessage());
                }
                delivery.settle();
            }
            catch (Exception e) {
                e.printStackTrace();
                Rejected rejected = new Rejected();
                ErrorCondition condition = new ErrorCondition();
                condition.setCondition(Symbol.valueOf((String)"failed"));
                condition.setDescription(e.getMessage());
                rejected.setError(condition);
                delivery.disposition((DeliveryState)rejected);
            }
            finally {
                buffer.release();
            }
        }
    }

    @Override
    public void onFlow(int credits) {
    }

    @Override
    public void close() throws HornetQAMQPException {
    }
}

